/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.tree.actions;

import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.tree.BaseDomElementNode;
import com.intellij.util.xml.tree.DomElementsGroupNode;
import com.intellij.util.xml.tree.DomModelTreeView;
import com.intellij.util.xml.ui.actions.AddDomElementAction;
import com.intellij.util.xml.ui.actions.DefaultAddAction;
import java.awt.Component;
import java.lang.reflect.Type;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddElementInCollectionAction
extends AddDomElementAction {
    private DomModelTreeView myTreeView;

    public AddElementInCollectionAction() {
    }

    public AddElementInCollectionAction(DomModelTreeView treeView) {
        this.myTreeView = treeView;
    }

    protected DomModelTreeView getTreeView(AnActionEvent e) {
        if (this.myTreeView != null) {
            return this.myTreeView;
        }
        return (DomModelTreeView)DomModelTreeView.DATA_KEY.getData(e.getDataContext());
    }

    protected boolean isEnabled(AnActionEvent e) {
        DomModelTreeView treeView = this.getTreeView(e);
        boolean enabled = treeView != null;
        e.getPresentation().setEnabled(enabled);
        return enabled;
    }

    protected void showPopup(ListPopup groupPopup, AnActionEvent e) {
        if (this.myTreeView == null) {
            if (e.getPlace().equals(DomModelTreeView.DOM_MODEL_TREE_VIEW_POPUP)) {
                groupPopup.showInCenterOf((Component)this.getTreeView(e).getTree());
            } else {
                groupPopup.showInBestPositionFor(e.getDataContext());
            }
        } else {
            super.showPopup(groupPopup, e);
        }
    }

    @NotNull
    protected DomCollectionChildDescription[] getDomCollectionChildDescriptions(AnActionEvent e) {
        DomCollectionChildDescription[] domCollectionChildDescriptionArray;
        List consolidated;
        DomModelTreeView view = this.getTreeView(e);
        SimpleNode node = view.getTree().getSelectedNode();
        if (node instanceof BaseDomElementNode && (consolidated = ((BaseDomElementNode)node).getConsolidatedChildrenDescriptions()).size() > 0) {
            return consolidated.toArray(new DomCollectionChildDescription[consolidated.size()]);
        }
        DomElementsGroupNode groupNode = AddElementInCollectionAction.getDomElementsGroupNode(view);
        if (groupNode == null) {
            domCollectionChildDescriptionArray = DomCollectionChildDescription.EMPTY_ARRAY;
        } else {
            DomCollectionChildDescription[] domCollectionChildDescriptionArray2 = new DomCollectionChildDescription[1];
            domCollectionChildDescriptionArray = domCollectionChildDescriptionArray2;
            domCollectionChildDescriptionArray2[0] = groupNode.getChildDescription();
        }
        return domCollectionChildDescriptionArray;
    }

    protected DomElement getParentDomElement(AnActionEvent e) {
        DomModelTreeView view = this.getTreeView(e);
        SimpleNode node = view.getTree().getSelectedNode();
        if (node instanceof BaseDomElementNode && ((BaseDomElementNode)node).getConsolidatedChildrenDescriptions().size() > 0) {
            return ((BaseDomElementNode)node).getDomElement();
        }
        DomElementsGroupNode groupNode = AddElementInCollectionAction.getDomElementsGroupNode(view);
        return groupNode == null ? null : groupNode.getDomElement();
    }

    protected JComponent getComponent(AnActionEvent e) {
        return this.getTreeView(e);
    }

    protected boolean showAsPopup() {
        return true;
    }

    protected String getActionText(AnActionEvent e) {
        DomElementsGroupNode selectedNode;
        String text = ApplicationBundle.message((String)"action.add", (Object[])new Object[0]);
        if (e.getPresentation().isEnabled() && (selectedNode = AddElementInCollectionAction.getDomElementsGroupNode(this.getTreeView(e))) != null) {
            Type type2 = selectedNode.getChildDescription().getType();
            text = text + " " + TypePresentationService.getService().getTypePresentableName(ReflectionUtil.getRawType((Type)type2));
        }
        return text;
    }

    @Nullable
    private static DomElementsGroupNode getDomElementsGroupNode(DomModelTreeView treeView) {
        for (SimpleNode simpleNode = treeView.getTree().getSelectedNode(); simpleNode != null; simpleNode = simpleNode.getParent()) {
            if (!(simpleNode instanceof DomElementsGroupNode)) continue;
            return (DomElementsGroupNode)simpleNode;
        }
        return null;
    }

    protected AnAction createAddingAction(AnActionEvent e, String name, Icon icon, Type type2, DomCollectionChildDescription description) {
        DomElement parentDomElement = this.getParentDomElement(e);
        if (parentDomElement instanceof MergedObject) {
            List implementations = ((MergedObject)parentDomElement).getImplementations();
            DefaultActionGroup actionGroup = new DefaultActionGroup(name, true);
            for (DomElement implementation : implementations) {
                XmlFile xmlFile = DomUtil.getFile((DomElement)implementation);
                actionGroup.add((AnAction)new MyDefaultAddAction(implementation, xmlFile.getName(), xmlFile.getIcon(0), e, type2, description));
            }
            return actionGroup;
        }
        return new MyDefaultAddAction(parentDomElement, name, icon, e, type2, description);
    }

    private class MyDefaultAddAction
    extends DefaultAddAction {
        private final DomElement myParent;
        private final DomModelTreeView myView;
        private final Type myType;
        private final DomCollectionChildDescription myDescription;

        public MyDefaultAddAction(DomElement parent, String name, Icon icon, AnActionEvent e, Type type2, DomCollectionChildDescription description) {
            super(name, name, icon);
            this.myType = type2;
            this.myDescription = description;
            this.myParent = parent;
            this.myView = AddElementInCollectionAction.this.getTreeView(e);
        }

        protected Type getElementType() {
            return this.myType;
        }

        protected DomCollectionChildDescription getDomCollectionChildDescription() {
            return this.myDescription;
        }

        protected DomElement getParentDomElement() {
            return this.myParent;
        }

        protected void afterAddition(@NotNull DomElement newElement) {
            DomElement copy = newElement.createStableCopy();
            ApplicationManager.getApplication().invokeLater(() -> this.myView.setSelectedDomElement(copy));
        }
    }
}

