/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.impl.source.PsiCodeFragmentImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.ui.UIBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ui.DomWrapper;
import com.intellij.util.xml.ui.EditorTextFieldControl;
import com.intellij.util.xml.ui.PsiClassPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PsiClassControl
extends EditorTextFieldControl<PsiClassPanel> {
    public PsiClassControl(DomWrapper<String> domWrapper) {
        super(domWrapper);
    }

    public PsiClassControl(DomWrapper<String> domWrapper, boolean commitOnEveryChange) {
        super(domWrapper, commitOnEveryChange);
    }

    @Override
    protected EditorTextField getEditorTextField(@NotNull PsiClassPanel component) {
        return ((ReferenceEditorWithBrowseButton)((Object)component.getComponent(0))).getEditorTextField();
    }

    @Override
    protected PsiClassPanel createMainComponent(PsiClassPanel boundedComponent, Project project2) {
        if (boundedComponent == null) {
            boundedComponent = new PsiClassPanel();
        }
        ReferenceEditorWithBrowseButton editor = JavaReferenceEditorUtil.createReferenceEditorWithBrowseButton(null, "", project2, true);
        Document document = ((EditorTextField)((Object)editor.getChildComponent())).getDocument();
        PsiCodeFragmentImpl fragment = (PsiCodeFragmentImpl)PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        assert (fragment != null);
        fragment.setIntentionActionsFilter(IntentionFilterOwner.IntentionActionsFilter.EVERYTHING_AVAILABLE);
        fragment.putUserData(ModuleUtil.KEY_MODULE, this.getDomWrapper().getExistingDomElement().getModule());
        return PsiClassControl.initReferenceEditorWithBrowseButton(boundedComponent, editor, this);
    }

    protected static <T extends JPanel> T initReferenceEditorWithBrowseButton(T boundedComponent, ReferenceEditorWithBrowseButton editor, final EditorTextFieldControl control) {
        boundedComponent.removeAll();
        boundedComponent.add((Component)((Object)editor));
        final GlobalSearchScope resolveScope = control.getDomWrapper().getResolveScope();
        editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object value2;
                DomElement domElement = control.getDomElement();
                ExtendClass extend = (ExtendClass)domElement.getAnnotation(ExtendClass.class);
                PsiClass baseClass = null;
                ClassFilter filter = null;
                if (extend != null) {
                    baseClass = JavaPsiFacade.getInstance((Project)control.getProject()).findClass(extend.value(), resolveScope);
                    if (extend.instantiatable()) {
                        filter = ClassFilter.INSTANTIABLE;
                    }
                }
                PsiClass initialClass = null;
                if (domElement instanceof GenericDomValue && (value2 = ((GenericDomValue)domElement).getValue()) instanceof PsiClass) {
                    initialClass = (PsiClass)value2;
                }
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)control.getProject()).createInheritanceClassChooser(UIBundle.message((String)"choose.class", (Object[])new Object[0]), resolveScope, baseClass, initialClass, filter);
                chooser.showDialog();
                PsiClass psiClass = chooser.getSelected();
                if (psiClass != null) {
                    control.setValue(psiClass.getQualifiedName());
                }
            }
        });
        return boundedComponent;
    }
}

