/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.LongRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import com.intellij.openapi.vcs.versionBrowser.VcsRevisionNumberAware;
import java.util.Collection;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class CommittedChangeListForRevision
extends CommittedChangeListImpl
implements VcsRevisionNumberAware {
    @NotNull
    private VcsRevisionNumber myRevisionNumber;

    public CommittedChangeListForRevision(@NotNull String subject, @NotNull String comment, @NotNull String committerName, @NotNull Date commitDate, @NotNull Collection<Change> changes, @NotNull VcsRevisionNumber revisionNumber) {
        super(subject, comment, committerName, CommittedChangeListForRevision.getLong(revisionNumber), commitDate, changes);
        this.myRevisionNumber = revisionNumber;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    private static long getLong(@NotNull VcsRevisionNumber number) {
        if (number instanceof LongRevisionNumber) {
            return ((LongRevisionNumber)number).getLongRevisionNumber();
        }
        return 0L;
    }
}

