/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;

public class VcsLocaleHelper {
    private static final String DEFAULT_EXECUTABLE_LOCALE_VALUE = "en_US.UTF-8";
    private static final String REGISTRY_KEY_SUFFIX = ".executable.locale";

    @NotNull
    public static String getDefaultLocaleFromRegistry(@NotNull String prefix) {
        String registryKey = prefix + REGISTRY_KEY_SUFFIX;
        try {
            return Registry.stringValue((String)registryKey);
        }
        catch (MissingResourceException e) {
            return DEFAULT_EXECUTABLE_LOCALE_VALUE;
        }
    }

    @NotNull
    public static Map<String, String> getDefaultLocaleEnvironmentVars(@NotNull String prefix) {
        LinkedHashMap envMap = ContainerUtil.newLinkedHashMap();
        String defaultLocale = VcsLocaleHelper.getDefaultLocaleFromRegistry(prefix);
        if (defaultLocale.isEmpty()) {
            return envMap;
        }
        envMap.put("LANGUAGE", "");
        envMap.put("LC_ALL", defaultLocale);
        return envMap;
    }
}

