/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CompressedRefs {
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final TIntObjectHashMap<TIntArrayList> myTags = new TIntObjectHashMap();
    @NotNull
    private final TIntObjectHashMap<List<VcsRef>> myBranches = new TIntObjectHashMap();

    public CompressedRefs(@NotNull Set<VcsRef> refs, @NotNull VcsLogStorage storage2) {
        this.myStorage = storage2;
        Ref root = new Ref();
        refs.forEach(ref -> {
            assert (root.get() == null || ((VirtualFile)root.get()).equals(ref.getRoot())) : "All references are supposed to be from the single root";
            root.set((Object)ref.getRoot());
            if (ref.getType().isBranch()) {
                CompressedRefs.putRef(this.myBranches, ref, this.myStorage);
            } else {
                CompressedRefs.putRefIndex(this.myTags, ref, this.myStorage);
            }
        });
        this.myTags.forEachValue(list -> {
            list.trimToSize();
            return true;
        });
        this.myStorage.flush();
    }

    @NotNull
    SmartList<VcsRef> refsToCommit(int index) {
        TIntArrayList tags;
        SmartList result2 = new SmartList();
        if (this.myBranches.containsKey(index)) {
            result2.addAll((Collection)this.myBranches.get(index));
        }
        if ((tags = (TIntArrayList)this.myTags.get(index)) != null) {
            tags.forEach(value2 -> {
                result2.add((Object)this.myStorage.getVcsRef(value2));
                return true;
            });
        }
        return result2;
    }

    @NotNull
    public Stream<VcsRef> streamBranches() {
        return TroveUtil.streamValues(this.myBranches).flatMap(Collection::stream);
    }

    @NotNull
    private Stream<VcsRef> streamTags() {
        return TroveUtil.streamValues(this.myTags).flatMapToInt(TroveUtil::stream).mapToObj(this.myStorage::getVcsRef);
    }

    @NotNull
    public Stream<VcsRef> stream() {
        return Stream.concat(this.streamBranches(), this.streamTags());
    }

    @NotNull
    public Collection<VcsRef> getRefs() {
        return new AbstractCollection<VcsRef>(){
            private final Supplier<Collection<VcsRef>> myLoadedRefs = Suppliers.memoize(() -> CompressedRefs.this.stream().collect(Collectors.toList()));

            @Override
            @NotNull
            public Iterator<VcsRef> iterator() {
                return ((Collection)this.myLoadedRefs.get()).iterator();
            }

            @Override
            public int size() {
                return ((Collection)this.myLoadedRefs.get()).size();
            }
        };
    }

    @NotNull
    public Collection<Integer> getCommits() {
        HashSet result2 = ContainerUtil.newHashSet();
        TroveUtil.streamKeys(this.myBranches).forEach(result2::add);
        TroveUtil.streamKeys(this.myTags).forEach(result2::add);
        return result2;
    }

    private static void putRef(@NotNull TIntObjectHashMap<List<VcsRef>> map2, @NotNull VcsRef ref, @NotNull VcsLogStorage storage2) {
        int index = storage2.getCommitIndex(ref.getCommitHash(), ref.getRoot());
        List list = (List)map2.get(index);
        if (list == null) {
            list = new SmartList();
            map2.put(index, (Object)list);
        }
        list.add(ref);
    }

    private static void putRefIndex(@NotNull TIntObjectHashMap<TIntArrayList> map2, @NotNull VcsRef ref, @NotNull VcsLogStorage storage2) {
        int index = storage2.getCommitIndex(ref.getCommitHash(), ref.getRoot());
        TIntArrayList list = (TIntArrayList)map2.get(index);
        if (list == null) {
            list = new TIntArrayList();
            map2.put(index, (Object)list);
        }
        list.add(storage2.getRefIndex(ref));
    }
}

