/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainingBranchesGetter {
    private static final Logger LOG = Logger.getInstance(ContainingBranchesGetter.class);
    @NotNull
    private final SequentialLimitedLifoExecutor<Task> myTaskExecutor;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final List<Runnable> myLoadingFinishedListeners = ContainerUtil.newArrayList();
    @NotNull
    private SLRUMap<CommitId, List<String>> myCache = ContainingBranchesGetter.createCache();
    @NotNull
    private Map<VirtualFile, ContainedInBranchCondition> myConditions = ContainerUtil.newHashMap();
    private int myCurrentBranchesChecksum;

    ContainingBranchesGetter(@NotNull VcsLogData logData, @NotNull Disposable parentDisposable) {
        this.myLogData = logData;
        this.myTaskExecutor = new SequentialLimitedLifoExecutor(parentDisposable, 10, task -> {
            List<String> branches = task.getContainingBranches(this.myLogData);
            ApplicationManager.getApplication().invokeLater(() -> {
                ((Task)task).cache.put((Object)new CommitId(((Task)task).hash, ((Task)task).root), (Object)branches);
                this.notifyListeners();
            });
        });
        this.myLogData.addDataPackChangeListener(dataPack -> {
            Collection<VcsRef> currentBranches = dataPack.getRefsModel().getBranches();
            int checksum = currentBranches.hashCode();
            if (this.myCurrentBranchesChecksum != 0 && this.myCurrentBranchesChecksum != checksum) {
                this.clearCache();
            }
            this.myCurrentBranchesChecksum = checksum;
        });
    }

    private void clearCache() {
        this.myCache = ContainingBranchesGetter.createCache();
        this.myTaskExecutor.clear();
        Map<VirtualFile, ContainedInBranchCondition> conditions = this.myConditions;
        this.myConditions = ContainerUtil.newHashMap();
        for (ContainedInBranchCondition c : conditions.values()) {
            c.dispose();
        }
        ApplicationManager.getApplication().invokeLater(this::notifyListeners);
    }

    public void addTaskCompletedListener(@NotNull Runnable runnable2) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.add(runnable2);
    }

    public void removeTaskCompletedListener(@NotNull Runnable runnable2) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.remove(runnable2);
    }

    private void notifyListeners() {
        LOG.assertTrue(EventQueue.isDispatchThread());
        for (Runnable listener2 : this.myLoadingFinishedListeners) {
            listener2.run();
        }
    }

    @Nullable
    public List<String> requestContainingBranches(@NotNull VirtualFile root, @NotNull Hash hash) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        List refs = (List)this.myCache.get((Object)new CommitId(hash, root));
        if (refs == null) {
            DataPack dataPack = this.myLogData.getDataPack();
            this.myTaskExecutor.queue(new Task(root, hash, this.myCache, dataPack.getPermanentGraph(), dataPack.getRefsModel()));
        }
        return refs;
    }

    @Nullable
    public List<String> getContainingBranchesFromCache(@NotNull VirtualFile root, @NotNull Hash hash) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        return (List)this.myCache.get((Object)new CommitId(hash, root));
    }

    @NotNull
    public Condition<CommitId> getContainedInBranchCondition(@NotNull String branchName, @NotNull VirtualFile root) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        DataPack dataPack = this.myLogData.getDataPack();
        if (dataPack == DataPack.EMPTY) {
            return Conditions.alwaysFalse();
        }
        PermanentGraph<Integer> graph = dataPack.getPermanentGraph();
        RefsModel refs = dataPack.getRefsModel();
        ContainedInBranchCondition condition2 = this.myConditions.get(root);
        if (condition2 == null || !condition2.getBranch().equals(branchName)) {
            VcsRef branchRef = (VcsRef)ContainerUtil.find((Iterable)refs.getBranches(), vcsRef -> vcsRef.getRoot().equals(root) && vcsRef.getName().equals(branchName));
            if (branchRef == null) {
                return Conditions.alwaysFalse();
            }
            condition2 = new ContainedInBranchCondition((Condition<Integer>)graph.getContainedInBranchCondition(Collections.singleton(this.myLogData.getCommitIndex(branchRef.getCommitHash(), branchRef.getRoot()))), branchName);
            this.myConditions.put(root, condition2);
        }
        return condition2;
    }

    @NotNull
    private static SLRUMap<CommitId, List<String>> createCache() {
        return new SLRUMap(1000, 1000);
    }

    @NotNull
    public List<String> getContainingBranchesSynchronously(@NotNull VirtualFile root, @NotNull Hash hash) {
        return this.doGetContainingBranches(this.myLogData.getDataPack(), root, hash);
    }

    @NotNull
    private List<String> doGetContainingBranches(@NotNull DataPack dataPack, @NotNull VirtualFile root, @NotNull Hash hash) {
        return new Task(root, hash, this.myCache, dataPack.getPermanentGraph(), dataPack.getRefsModel()).getContainingBranches(this.myLogData);
    }

    private class ContainedInBranchCondition
    implements Condition<CommitId> {
        @NotNull
        private final Condition<Integer> myCondition;
        @NotNull
        private final String myBranch;
        private volatile boolean isDisposed = false;

        public ContainedInBranchCondition(@NotNull Condition<Integer> condition2, String branch) {
            this.myCondition = condition2;
            this.myBranch = branch;
        }

        @NotNull
        public String getBranch() {
            return this.myBranch;
        }

        public boolean value(CommitId commitId) {
            if (this.isDisposed) {
                return false;
            }
            return this.myCondition.value((Object)ContainingBranchesGetter.this.myLogData.getCommitIndex(commitId.getHash(), commitId.getRoot()));
        }

        public void dispose() {
            this.isDisposed = true;
        }
    }

    private static class Task {
        private final VirtualFile root;
        private final Hash hash;
        private final SLRUMap<CommitId, List<String>> cache;
        @Nullable
        private final RefsModel refs;
        @Nullable
        private final PermanentGraph<Integer> graph;

        public Task(VirtualFile root, Hash hash, SLRUMap<CommitId, List<String>> cache2, @Nullable PermanentGraph<Integer> graph, @Nullable RefsModel refs) {
            this.root = root;
            this.hash = hash;
            this.cache = cache2;
            this.graph = graph;
            this.refs = refs;
        }

        @NotNull
        public List<String> getContainingBranches(@NotNull VcsLogData logData) {
            try {
                VcsLogProvider provider2 = logData.getLogProvider(this.root);
                if (this.graph != null && this.refs != null && ((Boolean)VcsLogProperties.get((VcsLogProvider)provider2, (VcsLogProperties.VcsLogProperty)VcsLogProperties.LIGHTWEIGHT_BRANCHES)).booleanValue()) {
                    Set branchesIndexes = this.graph.getContainingBranches((Object)logData.getCommitIndex(this.hash, this.root));
                    Collection branchesRefs = new HashSet();
                    for (Integer index : branchesIndexes) {
                        this.refs.refsToCommit(index).stream().filter(ref -> ref.getType().isBranch()).forEach(branchesRefs::add);
                    }
                    branchesRefs = ContainerUtil.sorted(branchesRefs, (Comparator)provider2.getReferenceManager().getLabelsOrderComparator());
                    ArrayList<String> branchesList = new ArrayList<String>();
                    for (VcsRef ref2 : branchesRefs) {
                        branchesList.add(ref2.getName());
                    }
                    return branchesList;
                }
                ArrayList<String> branches = new ArrayList<String>(provider2.getContainingBranches(this.root, this.hash));
                Collections.sort(branches);
                return branches;
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                return Collections.emptyList();
            }
        }
    }
}

