/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingDetails
implements VcsFullCommitDetails {
    private static final VcsUserImpl STUB_USER = new VcsUserImpl("", "");
    private static final String LOADING = "Loading...";
    @NotNull
    private final Computable<CommitId> myCommitIdComputable;
    private final long myLoadingTaskIndex;
    @Nullable
    private volatile CommitId myCommitId;

    public LoadingDetails(@NotNull Computable<CommitId> commitIdComputable, long loadingTaskIndex) {
        this.myCommitIdComputable = commitIdComputable;
        this.myLoadingTaskIndex = loadingTaskIndex;
    }

    protected CommitId getCommitId() {
        if (this.myCommitId == null) {
            this.myCommitId = (CommitId)this.myCommitIdComputable.compute();
        }
        return this.myCommitId;
    }

    public long getLoadingTaskIndex() {
        return this.myLoadingTaskIndex;
    }

    @NotNull
    public Collection<Change> getChanges() {
        return ContainerUtil.emptyList();
    }

    @NotNull
    public String getFullMessage() {
        return "";
    }

    @NotNull
    public VirtualFile getRoot() {
        return this.getCommitId().getRoot();
    }

    @NotNull
    public String getSubject() {
        return LOADING;
    }

    @NotNull
    public VcsUser getAuthor() {
        return STUB_USER;
    }

    @NotNull
    public VcsUser getCommitter() {
        return STUB_USER;
    }

    public long getAuthorTime() {
        return -1L;
    }

    public long getCommitTime() {
        return -1L;
    }

    @NotNull
    public Hash getId() {
        return this.getCommitId().getHash();
    }

    @NotNull
    public List<Hash> getParents() {
        return ContainerUtil.emptyList();
    }

    public long getTimestamp() {
        return -1L;
    }
}

