/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsCommitCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniDetailsGetter
extends AbstractDataGetter<VcsShortCommitDetails> {
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;

    MiniDetailsGetter(@NotNull VcsLogStorage storage2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull VcsLogIndex index, @NotNull Disposable parentDisposable) {
        super(storage2, logProviders, new VcsCommitCache(), index, parentDisposable);
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
    }

    @Override
    @Nullable
    protected VcsShortCommitDetails getFromAdditionalCache(int commitId) {
        return this.myTopCommitsDetailsCache.get(commitId);
    }

    @Override
    @NotNull
    protected List<? extends VcsShortCommitDetails> readDetails(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        return logProvider.readShortDetails(root, hashes);
    }
}

