/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.VcsShortCommitDetails;
import java.awt.EventQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsCommitCache<CommitId, T extends VcsShortCommitDetails> {
    private final SLRUMap<CommitId, T> myCache = new SLRUMap(5000, 5000);

    VcsCommitCache() {
    }

    public void put(@NotNull CommitId hash, @NotNull T commit) {
        assert (EventQueue.isDispatchThread());
        this.myCache.put(hash, commit);
    }

    public boolean isKeyCached(@NotNull CommitId hash) {
        assert (EventQueue.isDispatchThread());
        return this.myCache.get(hash) != null;
    }

    @Nullable
    public T get(@NotNull CommitId hash) {
        assert (EventQueue.isDispatchThread());
        return (T)((VcsShortCommitDetails)this.myCache.get(hash));
    }

    public void remove(@NotNull CommitId hash) {
        assert (EventQueue.isDispatchThread());
        this.myCache.remove(hash);
    }
}

