/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackChangeListener;
import com.intellij.vcs.log.data.EmptyIndex;
import com.intellij.vcs.log.data.InMemoryStorage;
import com.intellij.vcs.log.data.MiniDetailsGetter;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogRefresherImpl;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StopWatch;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogData
implements Disposable,
VcsLogDataProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogData.class);
    private static final Consumer<Exception> FAILING_EXCEPTION_HANDLER = e -> {
        if (!(e instanceof ProcessCanceledException)) {
            LOG.error((Throwable)e);
        }
    };
    public static final int RECENT_COMMITS_COUNT = Registry.intValue((String)"vcs.log.recent.commits.count");
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final BackgroundTaskQueue myDataLoaderQueue;
    @NotNull
    private final MiniDetailsGetter myMiniDetailsGetter;
    @NotNull
    private final CommitDetailsGetter myDetailsGetter;
    private final Map<VirtualFile, VcsUser> myCurrentUser = ContainerUtil.newHashMap();
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final ContainingBranchesGetter myContainingBranchesGetter;
    @NotNull
    private final VcsLogRefresherImpl myRefresher;
    @NotNull
    private final List<DataPackChangeListener> myDataPackChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsLogIndex myIndex;

    public VcsLogData(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull FatalErrorHandler fatalErrorsConsumer) {
        this.myProject = project2;
        this.myLogProviders = logProviders;
        this.myDataLoaderQueue = new BackgroundTaskQueue(project2, "Loading history...");
        this.myUserRegistry = (VcsUserRegistryImpl)ServiceManager.getService((Project)project2, VcsUserRegistry.class);
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        VcsLogProgress progress = new VcsLogProgress();
        Disposer.register((Disposable)this, (Disposable)progress);
        VcsLogCachesInvalidator invalidator = (VcsLogCachesInvalidator)((Object)CachesInvalidator.EP_NAME.findExtension(VcsLogCachesInvalidator.class));
        if (invalidator.isValid()) {
            this.myStorage = this.createStorage();
            this.myIndex = new VcsLogPersistentIndex(this.myProject, this.myStorage, progress, logProviders, this.myFatalErrorsConsumer, this);
        } else {
            String message2 = "Could not delete " + PersistentUtil.LOG_CACHE + "\nDelete it manually and restart IDEA.";
            LOG.error(message2);
            this.myFatalErrorsConsumer.displayFatalErrorMessage(message2);
            this.myStorage = new InMemoryStorage();
            this.myIndex = new EmptyIndex();
        }
        this.myTopCommitsDetailsCache = new TopCommitsCache(this.myStorage);
        this.myMiniDetailsGetter = new MiniDetailsGetter(this.myStorage, logProviders, this.myTopCommitsDetailsCache, this.myIndex, (Disposable)this);
        this.myDetailsGetter = new CommitDetailsGetter(this.myStorage, logProviders, this.myIndex, this);
        this.myRefresher = new VcsLogRefresherImpl(this.myProject, this.myStorage, this.myLogProviders, this.myUserRegistry, this.myIndex, progress, this.myTopCommitsDetailsCache, (Consumer<DataPack>)((Consumer)this::fireDataPackChangeEvent), FAILING_EXCEPTION_HANDLER, RECENT_COMMITS_COUNT);
        this.myContainingBranchesGetter = new ContainingBranchesGetter(this, this);
    }

    @NotNull
    private VcsLogStorage createStorage() {
        VcsLogStorage hashMap;
        try {
            hashMap = new VcsLogStorageImpl(this.myProject, this.myLogProviders, this.myFatalErrorsConsumer, this);
        }
        catch (IOException e) {
            hashMap = new InMemoryStorage();
            LOG.error("Falling back to in-memory hashes", (Throwable)e);
        }
        return hashMap;
    }

    private void fireDataPackChangeEvent(@NotNull DataPack dataPack) {
        ApplicationManager.getApplication().invokeLater(() -> {
            for (DataPackChangeListener listener2 : this.myDataPackChangeListeners) {
                listener2.onDataPackChange(dataPack);
            }
        });
    }

    public void addDataPackChangeListener(@NotNull DataPackChangeListener listener2) {
        this.myDataPackChangeListeners.add(listener2);
    }

    public void removeDataPackChangeListener(@NotNull DataPackChangeListener listener2) {
        this.myDataPackChangeListeners.remove(listener2);
    }

    @NotNull
    public DataPack getDataPack() {
        return this.myRefresher.getCurrentDataPack();
    }

    @Nullable
    public CommitId getCommitId(int commitIndex) {
        return this.myStorage.getCommitId(commitIndex);
    }

    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        return this.myStorage.getCommitIndex(hash, root);
    }

    @NotNull
    public VcsLogStorage getStorage() {
        return this.myStorage;
    }

    public void initialize() {
        StopWatch initSw = StopWatch.start("initialize");
        this.myDataLoaderQueue.clear();
        this.runInBackground((ThrowableConsumer<ProgressIndicator, VcsException>)((ThrowableConsumer)indicator -> {
            this.resetState();
            this.readCurrentUser();
            DataPack dataPack = this.myRefresher.readFirstBlock();
            this.fireDataPackChangeEvent(dataPack);
            initSw.report();
        }));
    }

    private void readCurrentUser() {
        StopWatch sw = StopWatch.start("readCurrentUser");
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : this.myLogProviders.entrySet()) {
            VirtualFile root = entry.getKey();
            try {
                VcsUser me = entry.getValue().getCurrentUser(root);
                if (me != null) {
                    this.myCurrentUser.put(root, me);
                    continue;
                }
                LOG.info("Username not configured for root " + root);
            }
            catch (VcsException e) {
                LOG.warn("Couldn't read the username from root " + root, (Throwable)e);
            }
        }
        sw.report();
    }

    private void resetState() {
        this.myTopCommitsDetailsCache.clear();
    }

    @NotNull
    public Set<VcsUser> getAllUsers() {
        return this.myUserRegistry.getUsers();
    }

    @NotNull
    public Map<VirtualFile, VcsUser> getCurrentUser() {
        return this.myCurrentUser;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        return this.myLogProviders.keySet();
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        return this.myLogProviders;
    }

    @NotNull
    public ContainingBranchesGetter getContainingBranchesGetter() {
        return this.myContainingBranchesGetter;
    }

    private void runInBackground(final @NotNull ThrowableConsumer<ProgressIndicator, VcsException> task) {
        Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, "Loading History...", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                try {
                    task.consume((Object)indicator);
                }
                catch (VcsException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.myDataLoaderQueue.run(backgroundable, null, this.myRefresher.getProgress().createProgressIndicator());
    }

    public void refreshSoftly(@NotNull Set<VirtualFile> roots) {
        this.myRefresher.refresh(roots);
    }

    public void refresh(@NotNull Collection<VirtualFile> roots) {
        this.myRefresher.refresh(roots);
    }

    public CommitDetailsGetter getCommitDetailsGetter() {
        return this.myDetailsGetter;
    }

    @NotNull
    public MiniDetailsGetter getMiniDetailsGetter() {
        return this.myMiniDetailsGetter;
    }

    public void dispose() {
        this.myDataLoaderQueue.clear();
        this.resetState();
    }

    @NotNull
    public VcsLogProvider getLogProvider(@NotNull VirtualFile root) {
        return this.myLogProviders.get(root);
    }

    @NotNull
    public VcsUserRegistryImpl getUserRegistry() {
        return this.myUserRegistry;
    }

    @NotNull
    public VcsLogProgress getProgress() {
        return this.myRefresher.getProgress();
    }

    @NotNull
    public TopCommitsCache getTopCommitsCache() {
        return this.myTopCommitsDetailsCache;
    }

    @NotNull
    public VcsLogIndex getIndex() {
        return this.myIndex;
    }
}

