/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogJoiner;
import com.intellij.vcs.log.data.VcsLogMultiRepoJoiner;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogRefreshNotEnoughDataException;
import com.intellij.vcs.log.data.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.RequirementsImpl;
import com.intellij.vcs.log.util.StopWatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogRefresherImpl
implements VcsLogRefresher {
    private static final Logger LOG = Logger.getInstance(VcsLogRefresherImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final VcsLogIndex myIndex;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final Consumer<Exception> myExceptionHandler;
    @NotNull
    private final VcsLogProgress myProgress;
    private final int myRecentCommitCount;
    @NotNull
    private final SingleTaskController<RefreshRequest, DataPack> mySingleTaskController;
    @NotNull
    private volatile DataPack myDataPack = DataPack.EMPTY;

    public VcsLogRefresherImpl(@NotNull Project project2, @NotNull VcsLogStorage storage2, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsUserRegistryImpl userRegistry, @NotNull VcsLogIndex index, @NotNull VcsLogProgress progress, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull Consumer<DataPack> dataPackUpdateHandler, @NotNull Consumer<Exception> exceptionHandler, int recentCommitsCount) {
        this.myProject = project2;
        this.myStorage = storage2;
        this.myProviders = providers;
        this.myUserRegistry = userRegistry;
        this.myIndex = index;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myExceptionHandler = exceptionHandler;
        this.myRecentCommitCount = recentCommitsCount;
        this.myProgress = progress;
        this.mySingleTaskController = new SingleTaskController<RefreshRequest, DataPack>(dataPack -> {
            this.myDataPack = dataPack;
            dataPackUpdateHandler.consume(dataPack);
        }){

            @Override
            protected void startNewBackgroundTask() {
                VcsLogRefresherImpl.this.startNewBackgroundTask(new MyRefreshTask(VcsLogRefresherImpl.this.myDataPack));
            }
        };
    }

    protected void startNewBackgroundTask(@NotNull Task.Backgroundable refreshTask) {
        UIUtil.invokeLaterIfNeeded(() -> {
            LOG.debug("Starting a background task...");
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(refreshTask, this.myProgress.createProgressIndicator());
        });
    }

    @NotNull
    public DataPack getCurrentDataPack() {
        return this.myDataPack;
    }

    @Override
    @NotNull
    public DataPack readFirstBlock() {
        try {
            LogInfo data = this.loadRecentData(new CommitCountRequirements(this.myRecentCommitCount).asMap(this.myProviders.keySet()));
            Collection commits = data.getCommits();
            Map<VirtualFile, CompressedRefs> refs = data.getRefs();
            List compoundList = VcsLogRefresherImpl.multiRepoJoin(commits);
            compoundList = compoundList.subList(0, Math.min(this.myRecentCommitCount, compoundList.size()));
            this.myDataPack = DataPack.build(compoundList, refs, this.myProviders, this.myStorage, false);
            this.mySingleTaskController.request(RefreshRequest.RELOAD_ALL);
            return this.myDataPack;
        }
        catch (VcsException e) {
            this.myExceptionHandler.consume((Object)e);
            return DataPack.EMPTY;
        }
    }

    @NotNull
    private LogInfo loadRecentData(final @NotNull Map<VirtualFile, VcsLogProvider.Requirements> requirements) throws VcsException {
        final StopWatch sw = StopWatch.start("loading commits");
        final LogInfo logInfo = new LogInfo(this.myStorage);
        new ProviderIterator(){

            @Override
            public void each(@NotNull VirtualFile root, @NotNull VcsLogProvider provider2) throws VcsException {
                VcsLogProvider.DetailedLogData data = provider2.readFirstBlock(root, (VcsLogProvider.Requirements)requirements.get(root));
                logInfo.put(root, VcsLogRefresherImpl.this.compactCommits(data.getCommits(), root));
                logInfo.put(root, data.getRefs());
                VcsLogRefresherImpl.this.storeUsersAndDetails(data.getCommits());
                sw.rootCompleted(root);
            }
        }.iterate(this.getProvidersForRoots(requirements.keySet()));
        this.myUserRegistry.flush();
        this.myIndex.scheduleIndex(false);
        sw.report();
        return logInfo;
    }

    @NotNull
    private Map<VirtualFile, VcsLogProvider> getProvidersForRoots(@NotNull Set<VirtualFile> roots) {
        return ContainerUtil.map2Map(roots, root -> Pair.create((Object)root, (Object)this.myProviders.get(root)));
    }

    @Override
    public void refresh(@NotNull Collection<VirtualFile> rootsToRefresh) {
        if (!rootsToRefresh.isEmpty()) {
            this.mySingleTaskController.request(new RefreshRequest(rootsToRefresh));
        }
    }

    @NotNull
    private static <T extends GraphCommit<Integer>> List<T> multiRepoJoin(@NotNull Collection<List<T>> commits) {
        StopWatch sw = StopWatch.start("multi-repo join");
        List joined = new VcsLogMultiRepoJoiner().join(commits);
        sw.report();
        return joined;
    }

    @NotNull
    private List<GraphCommit<Integer>> compactCommits(@NotNull List<? extends TimedVcsCommit> commits, final @NotNull VirtualFile root) {
        StopWatch sw = StopWatch.start("compacting commits");
        List map2 = ContainerUtil.map(commits, (Function)new Function<TimedVcsCommit, GraphCommit<Integer>>(){

            @NotNull
            public GraphCommit<Integer> fun(@NotNull TimedVcsCommit commit) {
                return VcsLogRefresherImpl.this.compactCommit(commit, root);
            }
        });
        this.myStorage.flush();
        sw.report();
        return map2;
    }

    @NotNull
    private GraphCommitImpl<Integer> compactCommit(@NotNull TimedVcsCommit commit, @NotNull VirtualFile root) {
        List parents = ContainerUtil.map((Collection)commit.getParents(), (Function)((NotNullFunction)hash -> this.myStorage.getCommitIndex((Hash)hash, root)));
        int index = this.myStorage.getCommitIndex((Hash)commit.getId(), root);
        this.myIndex.markForIndexing(index, root);
        return new GraphCommitImpl<Integer>(index, parents, commit.getTimestamp());
    }

    private void storeUsersAndDetails(@NotNull List<? extends VcsCommitMetadata> metadatas) {
        for (VcsCommitMetadata vcsCommitMetadata : metadatas) {
            this.myUserRegistry.addUser(vcsCommitMetadata.getAuthor());
            this.myUserRegistry.addUser(vcsCommitMetadata.getCommitter());
        }
        this.myTopCommitsDetailsCache.storeDetails(metadatas);
    }

    @NotNull
    public VcsLogProgress getProgress() {
        return this.myProgress;
    }

    private static class LogInfo {
        private final VcsLogStorage myStorage;
        private final Map<VirtualFile, CompressedRefs> myRefs = ContainerUtil.newHashMap();
        private final Map<VirtualFile, List<GraphCommit<Integer>>> myCommits = ContainerUtil.newHashMap();

        public LogInfo(VcsLogStorage storage2) {
            this.myStorage = storage2;
        }

        void put(@NotNull VirtualFile root, @NotNull List<GraphCommit<Integer>> commits) {
            this.myCommits.put(root, commits);
        }

        void put(@NotNull VirtualFile root, @NotNull Set<VcsRef> refs) {
            this.myRefs.put(root, new CompressedRefs(refs, this.myStorage));
        }

        void put(@NotNull VirtualFile root, @NotNull CompressedRefs refs) {
            this.myRefs.put(root, refs);
        }

        @NotNull
        Collection<List<GraphCommit<Integer>>> getCommits() {
            return this.myCommits.values();
        }

        List<GraphCommit<Integer>> getCommits(@NotNull VirtualFile root) {
            return this.myCommits.get(root);
        }

        @NotNull
        Map<VirtualFile, CompressedRefs> getRefs() {
            return this.myRefs;
        }
    }

    private static class CommitCountRequirements
    implements VcsLogProvider.Requirements {
        private final int myCommitCount;

        public CommitCountRequirements(int commitCount) {
            this.myCommitCount = commitCount;
        }

        public int getCommitCount() {
            return this.myCommitCount;
        }

        @NotNull
        Map<VirtualFile, VcsLogProvider.Requirements> asMap(@NotNull Collection<VirtualFile> roots) {
            return ContainerUtil.map2Map(roots, root -> Pair.create((Object)root, (Object)this));
        }
    }

    private static abstract class ProviderIterator {
        private ProviderIterator() {
        }

        abstract void each(@NotNull VirtualFile var1, @NotNull VcsLogProvider var2) throws VcsException;

        final void iterate(@NotNull Map<VirtualFile, VcsLogProvider> providers) throws VcsException {
            for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
                this.each(entry.getKey(), entry.getValue());
            }
        }
    }

    private static class RefreshRequest {
        private static final RefreshRequest RELOAD_ALL = new RefreshRequest((Collection)Collections.emptyList()){

            @Override
            public String toString() {
                return "RELOAD_ALL";
            }
        };
        private final Collection<VirtualFile> rootsToRefresh;

        RefreshRequest(@NotNull Collection<VirtualFile> rootsToRefresh) {
            this.rootsToRefresh = rootsToRefresh;
        }

        public String toString() {
            return "{" + this.rootsToRefresh + "}";
        }
    }

    private class MyRefreshTask
    extends Task.Backgroundable {
        @NotNull
        private DataPack myCurrentDataPack;
        @NotNull
        private final LogInfo myLoadedInfo;

        MyRefreshTask(DataPack currentDataPack) {
            super(VcsLogRefresherImpl.this.myProject, "Refreshing History...", false);
            this.myLoadedInfo = new LogInfo(VcsLogRefresherImpl.this.myStorage);
            this.myCurrentDataPack = currentDataPack;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            LOG.debug("Refresh task started");
            indicator.setIndeterminate(true);
            DataPack dataPack = this.myCurrentDataPack;
            while (true) {
                List<RefreshRequest> requests = VcsLogRefresherImpl.this.mySingleTaskController.popRequests();
                Collection<VirtualFile> rootsToRefresh = this.getRootsToRefresh(requests);
                LOG.debug("Requests: " + requests + ". roots to refresh: " + rootsToRefresh);
                if (rootsToRefresh.isEmpty()) break;
                dataPack = this.doRefresh(rootsToRefresh);
            }
            VcsLogRefresherImpl.this.mySingleTaskController.taskCompleted(dataPack);
        }

        @NotNull
        private Collection<VirtualFile> getRootsToRefresh(@NotNull List<RefreshRequest> requests) {
            ArrayList rootsToRefresh = ContainerUtil.newArrayList();
            for (RefreshRequest request : requests) {
                if (request == RefreshRequest.RELOAD_ALL) {
                    this.myCurrentDataPack = DataPack.EMPTY;
                    return VcsLogRefresherImpl.this.myProviders.keySet();
                }
                rootsToRefresh.addAll(request.rootsToRefresh);
            }
            return rootsToRefresh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private DataPack doRefresh(@NotNull Collection<VirtualFile> roots) {
            StopWatch sw = StopWatch.start("refresh");
            PermanentGraph<Integer> permanentGraph = this.myCurrentDataPack.isFull() ? this.myCurrentDataPack.getPermanentGraph() : null;
            Map<VirtualFile, CompressedRefs> currentRefs = this.myCurrentDataPack.getRefsModel().getAllRefsByRoot();
            try {
                if (permanentGraph != null) {
                    int commitCount = VcsLogRefresherImpl.this.myRecentCommitCount;
                    for (int attempt = 0; attempt <= 1; ++attempt) {
                        this.loadLogAndRefs(roots, currentRefs, commitCount);
                        List compoundLog = VcsLogRefresherImpl.multiRepoJoin(this.myLoadedInfo.getCommits());
                        Map<VirtualFile, CompressedRefs> allNewRefs = this.getAllNewRefs(this.myLoadedInfo, currentRefs);
                        List<GraphCommit<Integer>> joinedFullLog = this.join(compoundLog, permanentGraph.getAllCommits(), currentRefs, allNewRefs);
                        if (joinedFullLog == null) {
                            commitCount *= 5;
                            continue;
                        }
                        DataPack dataPack = DataPack.build(joinedFullLog, allNewRefs, VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myStorage, true);
                        return dataPack;
                    }
                    LOG.info("Couldn't join " + commitCount / 5 + " recent commits to the log (" + permanentGraph.getAllCommits().size() + " commits)");
                }
                DataPack commitCount = this.loadFullLog();
                return commitCount;
            }
            catch (Exception e) {
                VcsLogRefresherImpl.this.myExceptionHandler.consume((Object)e);
                DataPack dataPack = DataPack.EMPTY;
                return dataPack;
            }
            finally {
                sw.report();
            }
        }

        @NotNull
        private Map<VirtualFile, CompressedRefs> getAllNewRefs(@NotNull LogInfo newInfo, @NotNull Map<VirtualFile, CompressedRefs> previousRefs) {
            HashMap result2 = ContainerUtil.newHashMap();
            for (VirtualFile root : previousRefs.keySet()) {
                CompressedRefs newInfoRefs = newInfo.getRefs().get(root);
                result2.put(root, newInfoRefs != null ? newInfoRefs : previousRefs.get(root));
            }
            return result2;
        }

        private void loadLogAndRefs(@NotNull Collection<VirtualFile> roots, @NotNull Map<VirtualFile, CompressedRefs> prevRefs, int commitCount) throws VcsException {
            LogInfo logInfo = VcsLogRefresherImpl.this.loadRecentData(this.prepareRequirements(roots, commitCount, prevRefs));
            for (VirtualFile root : roots) {
                this.myLoadedInfo.put(root, logInfo.getCommits(root));
                this.myLoadedInfo.put(root, logInfo.getRefs().get(root));
            }
        }

        @NotNull
        private Map<VirtualFile, VcsLogProvider.Requirements> prepareRequirements(@NotNull Collection<VirtualFile> roots, int commitCount, @NotNull Map<VirtualFile, CompressedRefs> prevRefs) {
            HashMap requirements = ContainerUtil.newHashMap();
            for (VirtualFile root : roots) {
                requirements.put(root, new RequirementsImpl(commitCount, true, prevRefs.get(root).getRefs()));
            }
            return requirements;
        }

        @Nullable
        private List<GraphCommit<Integer>> join(@NotNull List<? extends GraphCommit<Integer>> recentCommits, @NotNull List<GraphCommit<Integer>> fullLog, @NotNull Map<VirtualFile, CompressedRefs> previousRefs, @NotNull Map<VirtualFile, CompressedRefs> newRefs) {
            StopWatch sw = StopWatch.start("joining new commits");
            Collection prevRefIndices = previousRefs.values().stream().flatMap(refs -> refs.getCommits().stream()).collect(Collectors.toSet());
            Collection newRefIndices = newRefs.values().stream().flatMap(refs -> refs.getCommits().stream()).collect(Collectors.toSet());
            try {
                List commits = (List)new VcsLogJoiner<CommitId, GraphCommit<Integer>>().addCommits(fullLog, prevRefIndices, recentCommits, newRefIndices).first;
                sw.report();
                return commits;
            }
            catch (VcsLogRefreshNotEnoughDataException e) {
                LOG.info((Throwable)e);
            }
            catch (IllegalStateException e) {
                LOG.info((Throwable)e);
            }
            return null;
        }

        @NotNull
        private DataPack loadFullLog() throws VcsException {
            StopWatch sw = StopWatch.start("full log reload");
            LogInfo logInfo = this.readFullLogFromVcs();
            List graphCommits = VcsLogRefresherImpl.multiRepoJoin(logInfo.getCommits());
            DataPack dataPack = DataPack.build(graphCommits, logInfo.getRefs(), VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myStorage, true);
            sw.report();
            return dataPack;
        }

        @NotNull
        private LogInfo readFullLogFromVcs() throws VcsException {
            final StopWatch sw = StopWatch.start("read full log from VCS");
            final LogInfo logInfo = new LogInfo(VcsLogRefresherImpl.this.myStorage);
            new ProviderIterator(){

                @Override
                void each(@NotNull VirtualFile root, @NotNull VcsLogProvider provider2) throws VcsException {
                    ArrayList graphCommits = ContainerUtil.newArrayList();
                    VcsLogProvider.LogData data = provider2.readAllHashes(root, commit -> graphCommits.add(VcsLogRefresherImpl.this.compactCommit(commit, root)));
                    logInfo.put(root, graphCommits);
                    logInfo.put(root, data.getRefs());
                    VcsLogRefresherImpl.this.myUserRegistry.addUsers(data.getUsers());
                    sw.rootCompleted(root);
                }
            }.iterate(VcsLogRefresherImpl.this.myProviders);
            VcsLogRefresherImpl.this.myUserRegistry.flush();
            VcsLogRefresherImpl.this.myIndex.scheduleIndex(true);
            sw.report();
            return logInfo;
        }
    }
}

