/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUserRegistryImpl
implements Disposable,
VcsUserRegistry {
    private static final File USER_CACHE_APP_DIR = new File(PathManager.getSystemPath(), "vcs-users");
    private static final Logger LOG = Logger.getInstance(VcsUserRegistryImpl.class);
    private static final int STORAGE_VERSION = 2;
    private static final PersistentEnumeratorBase.DataFilter ACCEPT_ALL_DATA_FILTER = id -> true;
    @Nullable
    private final PersistentEnumeratorBase<VcsUser> myPersistentEnumerator;
    @NotNull
    private final Interner<VcsUser> myInterner;

    VcsUserRegistryImpl(@NotNull Project project2) {
        File mapFile = new File(USER_CACHE_APP_DIR, project2.getLocationHash() + "." + 2);
        this.myPersistentEnumerator = this.initEnumerator(mapFile);
        this.myInterner = new Interner();
    }

    @Nullable
    private PersistentEnumeratorBase<VcsUser> initEnumerator(@NotNull File mapFile) {
        try {
            return (PersistentEnumeratorBase)IOUtil.openCleanOrResetBroken(() -> new PersistentBTreeEnumerator(mapFile, (KeyDescriptor)new MyDescriptor(), Page.PAGE_SIZE, null, 2), (File)mapFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public VcsUser createUser(@NotNull String name, @NotNull String email) {
        Interner<VcsUser> interner = this.myInterner;
        synchronized (interner) {
            return (VcsUser)this.myInterner.intern((Object)new VcsUserImpl(name, email));
        }
    }

    public void addUser(@NotNull VcsUser user) {
        try {
            if (this.myPersistentEnumerator != null) {
                this.myPersistentEnumerator.enumerate((Object)user);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void addUsers(@NotNull Collection<VcsUser> users) {
        for (VcsUser user : users) {
            this.addUser(user);
        }
    }

    @NotNull
    public Set<VcsUser> getUsers() {
        try {
            Set users = this.myPersistentEnumerator != null ? this.myPersistentEnumerator.getAllDataObjects(ACCEPT_ALL_DATA_FILTER) : Collections.emptySet();
            return ContainerUtil.newHashSet(users);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return Collections.emptySet();
        }
    }

    public void flush() {
        if (this.myPersistentEnumerator != null) {
            this.myPersistentEnumerator.force();
        }
    }

    public void dispose() {
        try {
            if (this.myPersistentEnumerator != null) {
                this.myPersistentEnumerator.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public int getUserId(@NotNull VcsUser user) throws IOException {
        return this.myPersistentEnumerator.enumerate((Object)user);
    }

    @Nullable
    public VcsUser getUserById(Integer userId) throws IOException {
        return (VcsUser)this.myPersistentEnumerator.valueOf(userId.intValue());
    }

    private class MyDescriptor
    implements KeyDescriptor<VcsUser> {
        private MyDescriptor() {
        }

        public void save(@NotNull DataOutput out, VcsUser value2) throws IOException {
            IOUtil.writeUTF((DataOutput)out, (String)value2.getName());
            IOUtil.writeUTF((DataOutput)out, (String)value2.getEmail());
        }

        public VcsUser read(@NotNull DataInput in) throws IOException {
            String name = IOUtil.readUTF((DataInput)in);
            String email = IOUtil.readUTF((DataInput)in);
            return VcsUserRegistryImpl.this.createUser(name, email);
        }

        public int getHashCode(VcsUser value2) {
            return value2.hashCode();
        }

        public boolean isEqual(VcsUser val1, VcsUser val2) {
            return val1.equals(val2);
        }
    }
}

