/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.indexing.StorageException;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexDataGetter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final VcsLogPersistentIndex.IndexStorage myIndexStorage;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;

    public IndexDataGetter(@NotNull Project project2, @NotNull Set<VirtualFile> roots, @NotNull VcsLogPersistentIndex.IndexStorage storage2, @NotNull FatalErrorHandler fatalErrorsConsumer) {
        this.myProject = project2;
        this.myRoots = roots;
        this.myIndexStorage = storage2;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
    }

    @Nullable
    public String getFullMessage(int index) {
        try {
            return (String)this.myIndexStorage.messages.get((Object)index);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return null;
        }
    }

    @NotNull
    public Set<FilePath> getFileNames(@NotNull FilePath path, int commit) {
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        if (this.myRoots.contains(root)) {
            try {
                return this.myIndexStorage.paths.getFileNames(path, commit);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, (Exception)e);
            }
        }
        return Collections.emptySet();
    }

    @NotNull
    public FileNamesData buildFileNamesData(@NotNull FilePath path) {
        FileNamesData result2 = new FileNamesData();
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        if (this.myRoots.contains(root)) {
            try {
                this.myIndexStorage.paths.iterateCommits(Collections.singleton(path), (paths, commit) -> result2.add(commit, (Couple<FilePath>)paths));
                result2.pack();
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, (Exception)e);
            }
        }
        return result2;
    }

    public static class FileNamesData {
        @NotNull
        private final Interner<Set<FilePath>> myPathsInterner = new Interner();
        @NotNull
        private final TIntObjectHashMap<Set<FilePath>> myCommitsToPaths = new TIntObjectHashMap();
        @NotNull
        private final TIntObjectHashMap<Set<UnorderedPair<FilePath>>> myCommitsToRenames = new TIntObjectHashMap();

        public boolean hasRenames() {
            return !this.myCommitsToRenames.isEmpty();
        }

        private void addPath(int commit, @NotNull FilePath path) {
            Set paths = (Set)this.myCommitsToPaths.get(commit);
            if (paths == null) {
                paths = new SmartHashSet();
                this.myCommitsToPaths.put(commit, (Object)paths);
            }
            paths.add(path);
        }

        private void addRename(int commit, @NotNull Couple<FilePath> path) {
            Set paths = (Set)this.myCommitsToRenames.get(commit);
            if (paths == null) {
                paths = ContainerUtil.newHashSet();
                this.myCommitsToRenames.put(commit, (Object)paths);
            }
            paths.add(new UnorderedPair(path.first, path.second));
        }

        private void add(int commit, @NotNull Couple<FilePath> paths) {
            if (paths.second == null) {
                this.addPath(commit, (FilePath)paths.first);
            } else {
                this.addRename(commit, paths);
            }
        }

        public boolean affects(int commit, @NotNull FilePath path) {
            Set paths = (Set)this.myCommitsToPaths.get(commit);
            if (paths != null && paths.contains(path)) {
                return true;
            }
            return this.getRenamedPath(commit, path) != null;
        }

        @Nullable
        public FilePath getRenamedPath(int commit, @Nullable FilePath newName) {
            Set renames = (Set)this.myCommitsToRenames.get(commit);
            if (renames == null) {
                return null;
            }
            for (UnorderedPair rename : renames) {
                if (((FilePath)rename.first).equals(newName)) {
                    return (FilePath)rename.second;
                }
                if (!((FilePath)rename.second).equals(newName)) continue;
                return (FilePath)rename.first;
            }
            return null;
        }

        @Nullable
        public FilePath getPreviousPath(int commit, @Nullable FilePath path) {
            Set paths = (Set)this.myCommitsToPaths.get(commit);
            if (paths != null && paths.contains(path)) {
                return path;
            }
            return this.getRenamedPath(commit, path);
        }

        public void remove(int commit) {
            this.myCommitsToPaths.remove(commit);
            this.myCommitsToRenames.remove(commit);
        }

        public void retain(int commit, @NotNull FilePath path, @NotNull FilePath previousPath) {
            if (path.equals(previousPath)) {
                this.myCommitsToPaths.put(commit, this.myPathsInterner.intern((Object)ContainerUtil.set((Object[])new FilePath[]{path})));
                this.myCommitsToRenames.remove(commit);
            } else {
                this.myCommitsToPaths.remove(commit);
                this.myCommitsToRenames.put(commit, (Object)ContainerUtil.set((Object[])new UnorderedPair[]{new UnorderedPair((Object)path, (Object)previousPath)}));
            }
        }

        @NotNull
        public Set<FilePath> getAffectedPaths(int commit) {
            Set renames;
            SmartHashSet result2 = new SmartHashSet();
            Set paths = (Set)this.myCommitsToPaths.get(commit);
            if (paths != null) {
                result2.addAll(paths);
            }
            if ((renames = (Set)this.myCommitsToRenames.get(commit)) != null) {
                for (UnorderedPair rename : renames) {
                    result2.add(rename.first);
                    result2.add(rename.second);
                }
            }
            return result2;
        }

        void pack() {
            TIntObjectIterator iterator = this.myCommitsToPaths.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                iterator.setValue(this.myPathsInterner.intern(iterator.value()));
            }
        }
    }
}

