/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.util.Computable;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import org.jetbrains.annotations.NotNull;

public class IndexedDetails
extends LoadingDetails {
    @NotNull
    private final IndexDataGetter myDataGetter;
    private final int myCommitIndex;

    public IndexedDetails(@NotNull IndexDataGetter dataGetter, @NotNull VcsLogStorage storage2, int commitIndex, long loadingTaskIndex) {
        super((Computable<CommitId>)((Computable)() -> storage2.getCommitId(commitIndex)), loadingTaskIndex);
        this.myDataGetter = dataGetter;
        this.myCommitIndex = commitIndex;
    }

    @Override
    @NotNull
    public String getFullMessage() {
        String message2 = this.myDataGetter.getFullMessage(this.myCommitIndex);
        if (message2 != null) {
            return message2;
        }
        return super.getFullMessage();
    }

    @Override
    @NotNull
    public String getSubject() {
        String message2 = this.myDataGetter.getFullMessage(this.myCommitIndex);
        if (message2 != null) {
            return IndexedDetails.getSubject(message2);
        }
        return super.getSubject();
    }

    @NotNull
    public static String getSubject(@NotNull String fullMessage) {
        int subjectEnd = fullMessage.indexOf("\n\n");
        if (subjectEnd > 0) {
            return fullMessage.substring(0, subjectEnd).replace("\n", " ");
        }
        return fullMessage.replace("\n", " ");
    }
}

