/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.PersistentUtil;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;

public class VcsLogFullDetailsIndex<T>
implements Disposable {
    protected static final String INDEX = "index";
    @NotNull
    protected final MyMapReduceIndex myMapReduceIndex;
    @NotNull
    private final ID<Integer, T> myID;
    @NotNull
    private final String myLogId;
    @NotNull
    private final String myName;
    @NotNull
    protected final DataIndexer<Integer, T, VcsFullCommitDetails> myIndexer;
    @NotNull
    private final FatalErrorHandler myFatalErrorHandler;

    public VcsLogFullDetailsIndex(@NotNull String logId, @NotNull String name, int version, @NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, @NotNull DataExternalizer<T> externalizer, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        this.myID = ID.create((String)name);
        this.myName = name;
        this.myLogId = logId;
        this.myIndexer = indexer;
        this.myFatalErrorHandler = fatalErrorHandler;
        this.myMapReduceIndex = new MyMapReduceIndex(this.myIndexer, externalizer, version);
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    @NotNull
    public TIntHashSet getCommitsWithAnyKey(@NotNull Set<Integer> keys) throws StorageException {
        TIntHashSet result2 = new TIntHashSet();
        for (Integer key2 : keys) {
            this.iterateCommitIds(key2, (Consumer<Integer>)((Consumer)arg_0 -> ((TIntHashSet)result2).add(arg_0)));
        }
        return result2;
    }

    @NotNull
    public TIntHashSet getCommitsWithAllKeys(@NotNull Collection<Integer> keys) throws StorageException {
        return InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)this.myMapReduceIndex, keys, k -> {
            ProgressManager.checkCanceled();
            return true;
        }, null, null);
    }

    private void iterateCommitIds(int key2, @NotNull Consumer<Integer> consumer2) throws StorageException {
        ValueContainer data = this.myMapReduceIndex.getData(key2);
        data.forEach((id, value2) -> {
            consumer2.consume((Object)id);
            return true;
        });
    }

    protected void iterateCommitIdsAndValues(int key2, @NotNull ObjIntConsumer<T> consumer2) throws StorageException {
        this.myMapReduceIndex.getData(key2).forEach((id, value2) -> {
            consumer2.accept(value2, id);
            return true;
        });
    }

    protected boolean iterateCommitIdsAndValues(int key2, @NotNull BiPredicate<T, Integer> consumer2) throws StorageException {
        return this.myMapReduceIndex.getData(key2).forEach((id, value2) -> consumer2.test(value2, id));
    }

    public void update(int commitId, @NotNull VcsFullCommitDetails details) throws IOException {
        this.myMapReduceIndex.update(commitId, details).compute();
    }

    public void flush() throws StorageException {
        this.myMapReduceIndex.flush();
    }

    public void dispose() {
        this.myMapReduceIndex.dispose();
    }

    @NotNull
    public static File getStorageFile(@NotNull String kind2, @NotNull String id) {
        return PersistentUtil.getStorageFile(INDEX, kind2, id, VcsLogPersistentIndex.getVersion(), false);
    }

    private static class EmptyForwardIndex<T>
    implements ForwardIndex<Integer, T> {
        private EmptyForwardIndex() {
        }

        @NotNull
        public InputDataDiffBuilder<Integer, T> getDiffBuilder(int inputId) {
            return new EmptyInputDataDiffBuilder(inputId);
        }

        public void putInputData(int inputId, @NotNull Map<Integer, T> data) throws IOException {
        }

        public void flush() {
        }

        public void clear() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    private class MyIndexExtension
    extends IndexExtension<Integer, T, VcsFullCommitDetails> {
        @NotNull
        private final DataIndexer<Integer, T, VcsFullCommitDetails> myIndexer;
        @NotNull
        private final DataExternalizer<T> myExternalizer;
        private final int myVersion;

        public MyIndexExtension(@NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, DataExternalizer<T> externalizer, int version) {
            this.myIndexer = indexer;
            this.myExternalizer = externalizer;
            this.myVersion = version;
        }

        @NotNull
        public ID<Integer, T> getName() {
            return VcsLogFullDetailsIndex.this.myID;
        }

        @NotNull
        public DataIndexer<Integer, T, VcsFullCommitDetails> getIndexer() {
            return this.myIndexer;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            return EnumeratorIntegerDescriptor.INSTANCE;
        }

        @NotNull
        public DataExternalizer<T> getValueExternalizer() {
            return this.myExternalizer;
        }

        public int getVersion() {
            return this.myVersion;
        }
    }

    private static class MyMapIndexStorage<T>
    extends MapIndexStorage<Integer, T> {
        public MyMapIndexStorage(@NotNull String name, @NotNull String logId, @NotNull DataExternalizer<T> externalizer) throws IOException {
            super(VcsLogFullDetailsIndex.getStorageFile(name, logId), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, externalizer, 5000, false);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }
    }

    private class MyMapReduceIndex
    extends MapReduceIndex<Integer, T, VcsFullCommitDetails> {
        public MyMapReduceIndex(@NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, DataExternalizer<T> externalizer, int version) throws IOException {
            super((IndexExtension)new MyIndexExtension(indexer, externalizer, version), new MyMapIndexStorage(VcsLogFullDetailsIndex.this.myName, VcsLogFullDetailsIndex.this.myLogId, externalizer), new EmptyForwardIndex());
        }

        public void checkCanceled() {
            ProgressManager.checkCanceled();
        }

        public void requestRebuild(@NotNull Exception ex) {
            VcsLogFullDetailsIndex.this.myFatalErrorHandler.consume((Object)this, ex);
        }
    }
}

