/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogMessagesTrigramIndex
extends VcsLogFullDetailsIndex<Void> {
    public static final String TRIGRAMS = "trigrams";

    public VcsLogMessagesTrigramIndex(@NotNull String logId, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        super(logId, TRIGRAMS, VcsLogPersistentIndex.getVersion(), new TrigramMessageIndexer(), VoidDataExternalizer.INSTANCE, fatalErrorHandler, disposableParent);
    }

    @Nullable
    public TIntHashSet getCommitsForSubstring(@NotNull String string) throws StorageException {
        MyTrigramProcessor trigramProcessor = new MyTrigramProcessor();
        TrigramBuilder.processTrigrams((CharSequence)string, (TrigramBuilder.TrigramProcessor)trigramProcessor);
        if (trigramProcessor.map.isEmpty()) {
            return null;
        }
        return this.getCommitsWithAllKeys(trigramProcessor.map.keySet());
    }

    private static class MyTrigramProcessor
    extends TrigramBuilder.TrigramProcessor {
        Map<Integer, Void> map;

        private MyTrigramProcessor() {
        }

        public boolean consumeTrigramsCount(int count) {
            this.map = new THashMap(count);
            return true;
        }

        public boolean execute(int value2) {
            this.map.put(value2, null);
            return true;
        }
    }

    public static class TrigramMessageIndexer
    implements DataIndexer<Integer, Void, VcsFullCommitDetails> {
        @NotNull
        public Map<Integer, Void> map(@NotNull VcsFullCommitDetails inputData) {
            MyTrigramProcessor trigramProcessor = new MyTrigramProcessor();
            TrigramBuilder.processTrigrams((CharSequence)inputData.getFullMessage(), (TrigramBuilder.TrigramProcessor)trigramProcessor);
            return trigramProcessor.map;
        }
    }
}

