/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;

public class VcsLogPathsIndex
extends VcsLogFullDetailsIndex<Integer> {
    private static final Logger LOG = Logger.getInstance(VcsLogPathsIndex.class);
    public static final String PATHS = "paths";
    public static final String INDEX_PATHS_IDS = "paths-ids";
    @NotNull
    private final PathsIndexer myPathsIndexer;

    public VcsLogPathsIndex(@NotNull String logId, @NotNull Set<VirtualFile> roots, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        super(logId, PATHS, VcsLogPersistentIndex.getVersion(), new PathsIndexer(VcsLogPathsIndex.createPathsEnumerator(logId), roots), new NullableIntKeyDescriptor(), fatalErrorHandler, disposableParent);
        this.myPathsIndexer = (PathsIndexer)this.myIndexer;
        this.myPathsIndexer.setFatalErrorConsumer((Consumer<Exception>)((Consumer)e -> fatalErrorHandler.consume(this, (Exception)e)));
    }

    @NotNull
    private static PersistentEnumeratorBase<String> createPathsEnumerator(@NotNull String logId) throws IOException {
        File storageFile = PersistentUtil.getStorageFile("index", INDEX_PATHS_IDS, logId, VcsLogPersistentIndex.getVersion(), true);
        return new PersistentBTreeEnumerator(storageFile, (KeyDescriptor)(SystemInfo.isFileSystemCaseSensitive ? EnumeratorStringDescriptor.INSTANCE : new ToLowerCaseStringDescriptor()), Page.PAGE_SIZE, null, VcsLogPersistentIndex.getVersion());
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myPathsIndexer.getPathsEnumerator().force();
    }

    @NotNull
    public TIntHashSet getCommitsForPaths(@NotNull Collection<FilePath> paths) throws IOException, StorageException {
        Set<Integer> allPathIds = this.getPathIds(paths);
        TIntHashSet result2 = new TIntHashSet();
        Set<Integer> renames = allPathIds;
        while (!renames.isEmpty()) {
            renames = this.addCommitsAndGetRenames(renames, allPathIds, result2);
            allPathIds.addAll(renames);
        }
        return result2;
    }

    @NotNull
    private Set<Integer> getPathIds(@NotNull Collection<FilePath> paths) throws IOException {
        HashSet allPathIds = ContainerUtil.newHashSet();
        for (FilePath path : paths) {
            allPathIds.add(this.myPathsIndexer.myPathsEnumerator.enumerate((Object)path.getPath()));
        }
        return allPathIds;
    }

    @NotNull
    public Set<FilePath> getFileNames(@NotNull FilePath path, int commit) throws IOException, StorageException {
        int startId = this.myPathsIndexer.myPathsEnumerator.enumerate((Object)path.getPath());
        HashSet startIds = ContainerUtil.newHashSet();
        startIds.add(startId);
        HashSet allIds = ContainerUtil.newHashSet((Iterable)startIds);
        HashSet newIds = ContainerUtil.newHashSet();
        HashSet resultIds = ContainerUtil.newHashSet();
        block0: while (!startIds.isEmpty()) {
            Iterator iterator = startIds.iterator();
            while (iterator.hasNext()) {
                int currentPathId = (Integer)iterator.next();
                boolean foundCommit = !this.iterateCommitIdsAndValues(currentPathId, (T renamedPathId, Integer commitId) -> {
                    if (commitId == commit) {
                        resultIds.add(currentPathId);
                        if (renamedPathId != null) {
                            resultIds.add(renamedPathId);
                        }
                        return false;
                    }
                    if (renamedPathId != null && !allIds.contains(renamedPathId)) {
                        newIds.add(renamedPathId);
                    }
                    return true;
                });
                if (!foundCommit) continue;
                break block0;
            }
            startIds = ContainerUtil.newHashSet((Iterable)newIds);
            allIds.addAll(startIds);
            newIds.clear();
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (Integer id : resultIds) {
            result2.add(VcsUtil.getFilePath((String)((String)this.myPathsIndexer.myPathsEnumerator.valueOf(id.intValue()))));
        }
        return result2;
    }

    public void iterateCommits(@NotNull Collection<FilePath> paths, @NotNull ObjIntConsumer<Couple<FilePath>> consumer2) throws IOException, StorageException {
        HashSet startIds = this.getPathIds(paths);
        HashSet allIds = ContainerUtil.newHashSet(startIds);
        HashSet newIds = ContainerUtil.newHashSet();
        while (!startIds.isEmpty()) {
            for (int currentPathId : startIds) {
                FilePath currentPath = VcsUtil.getFilePath((String)((String)this.myPathsIndexer.myPathsEnumerator.valueOf(currentPathId)));
                this.iterateCommitIdsAndValues(currentPathId, (T renamedPathId, int commitId) -> {
                    FilePath renamedPath = null;
                    if (renamedPathId != null) {
                        if (!allIds.contains(renamedPathId)) {
                            newIds.add(renamedPathId);
                        }
                        try {
                            renamedPath = VcsUtil.getFilePath((String)((String)this.myPathsIndexer.myPathsEnumerator.valueOf(renamedPathId.intValue())));
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    consumer2.accept(Couple.of((Object)currentPath, renamedPath), commitId);
                });
            }
            startIds = ContainerUtil.newHashSet((Iterable)newIds);
            allIds.addAll(startIds);
            newIds.clear();
        }
    }

    @NotNull
    public Set<Integer> addCommitsAndGetRenames(@NotNull Set<Integer> newPathIds, @NotNull Set<Integer> allPathIds, @NotNull TIntHashSet commits) throws StorageException {
        HashSet renames = ContainerUtil.newHashSet();
        for (Integer key2 : newPathIds) {
            this.iterateCommitIdsAndValues((int)key2, (T value2, int commit) -> {
                commits.add(commit);
                if (value2 != null && !allPathIds.contains(value2)) {
                    renames.add(value2);
                }
            });
        }
        return renames;
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myPathsIndexer.getPathsEnumerator().close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$400() {
        return LOG;
    }

    private static class ToLowerCaseStringDescriptor
    implements KeyDescriptor<String> {
        private ToLowerCaseStringDescriptor() {
        }

        public int getHashCode(String value2) {
            return CaseInsensitiveStringHashingStrategy.INSTANCE.computeHashCode(value2);
        }

        public boolean isEqual(String val1, String val2) {
            return CaseInsensitiveStringHashingStrategy.INSTANCE.equals(val1, val2);
        }

        public void save(@NotNull DataOutput out, String value2) throws IOException {
            IOUtil.writeUTF((DataOutput)out, (String)value2.toLowerCase());
        }

        public String read(@NotNull DataInput in) throws IOException {
            return IOUtil.readUTF((DataInput)in);
        }
    }

    private static class NullableIntKeyDescriptor
    implements DataExternalizer<Integer> {
        private NullableIntKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, Integer value2) throws IOException {
            if (value2 == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(value2);
            }
        }

        public Integer read(@NotNull DataInput in) throws IOException {
            if (in.readBoolean()) {
                return in.readInt();
            }
            return null;
        }
    }

    private static class PathsIndexer
    implements DataIndexer<Integer, Integer, VcsFullCommitDetails> {
        @NotNull
        private final PersistentEnumeratorBase<String> myPathsEnumerator;
        @NotNull
        private final Set<String> myRoots;
        @NotNull
        private Consumer<Exception> myFatalErrorConsumer = arg_0 -> ((Logger)VcsLogPathsIndex.access$400()).error(arg_0);

        private PathsIndexer(@NotNull PersistentEnumeratorBase<String> enumerator, @NotNull Set<VirtualFile> roots) {
            this.myPathsEnumerator = enumerator;
            this.myRoots = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
            for (VirtualFile root : roots) {
                this.myRoots.add(root.getPath());
            }
        }

        public void setFatalErrorConsumer(@NotNull Consumer<Exception> fatalErrorConsumer) {
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, Integer> map(@NotNull VcsFullCommitDetails inputData) {
            Collection<Object> moves;
            HashSet changedPaths;
            THashMap result2 = new THashMap();
            if (inputData instanceof VcsChangesLazilyParsedDetails) {
                changedPaths = ((VcsChangesLazilyParsedDetails)inputData).getModifiedPaths();
                moves = ((VcsChangesLazilyParsedDetails)inputData).getRenamedPaths();
            } else {
                moves = ContainerUtil.newHashSet();
                changedPaths = ContainerUtil.newHashSet();
                for (Change change : inputData.getChanges()) {
                    if (change.getAfterRevision() != null) {
                        changedPaths.add(change.getAfterRevision().getFile().getPath());
                    }
                    if (change.getBeforeRevision() != null) {
                        changedPaths.add(change.getBeforeRevision().getFile().getPath());
                    }
                    if (!change.getType().equals((Object)Change.Type.MOVED)) continue;
                    moves.add(Couple.of((Object)change.getBeforeRevision().getFile().getPath(), (Object)change.getAfterRevision().getFile().getPath()));
                }
            }
            this.getParentPaths(changedPaths).forEach(arg_0 -> this.lambda$map$0((Map)result2, arg_0));
            moves.forEach(arg_0 -> this.lambda$map$1((Map)result2, arg_0));
            return result2;
        }

        @NotNull
        private Collection<String> getParentPaths(@NotNull Collection<String> paths) {
            HashSet result2 = ContainerUtil.newHashSet();
            block0: for (String path : paths) {
                while (!path.isEmpty() && !result2.contains(path)) {
                    result2.add(path);
                    if (this.myRoots.contains(path)) continue block0;
                    path = PathUtil.getParentPath((String)path);
                }
            }
            return result2;
        }

        @NotNull
        public PersistentEnumeratorBase<String> getPathsEnumerator() {
            return this.myPathsEnumerator;
        }

        private /* synthetic */ void lambda$map$1(Map result2, Couple renamedPaths) {
            try {
                int beforeId = this.myPathsEnumerator.enumerate(renamedPaths.first);
                int afterId = this.myPathsEnumerator.enumerate(renamedPaths.second);
                result2.put(beforeId, afterId);
                result2.put(afterId, beforeId);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
        }

        private /* synthetic */ void lambda$map$0(Map result2, String changedPath) {
            try {
                result2.put(this.myPathsEnumerator.enumerate((Object)changedPath), null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
        }
    }
}

