/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIntHashSet;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogMessagesTrigramIndex;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogUserIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import com.intellij.vcs.log.util.PersistentSet;
import com.intellij.vcs.log.util.PersistentSetImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.THash;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPersistentIndex
implements VcsLogIndex,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogPersistentIndex.class);
    private static final int VERSION = 1;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsLogProgress myProgress;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @Nullable
    private final IndexStorage myIndexStorage;
    @Nullable
    private final IndexDataGetter myDataGetter;
    @NotNull
    private final SingleTaskController<IndexingRequest, Void> mySingleTaskController = new MySingleTaskController();
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myNumberOfTasks = ContainerUtil.newHashMap();
    @NotNull
    private final List<VcsLogIndex.IndexingFinishedListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private Map<VirtualFile, TIntHashSet> myCommitsToIndex = ContainerUtil.newHashMap();

    public VcsLogPersistentIndex(@NotNull Project project2, @NotNull VcsLogStorage storage2, @NotNull VcsLogProgress progress, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull FatalErrorHandler fatalErrorsConsumer, @NotNull Disposable disposableParent) {
        this.myStorage = storage2;
        this.myProject = project2;
        this.myProgress = progress;
        this.myProviders = providers;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        this.myRoots = ContainerUtil.newLinkedHashSet();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            if (!((Boolean)VcsLogProperties.get((VcsLogProvider)entry.getValue(), (VcsLogProperties.VcsLogProperty)VcsLogProperties.SUPPORTS_INDEXING)).booleanValue()) continue;
            this.myRoots.add(entry.getKey());
        }
        this.myUserRegistry = (VcsUserRegistryImpl)ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        this.myIndexStorage = this.createIndexStorage(fatalErrorsConsumer, PersistentUtil.calcLogId(this.myProject, providers));
        this.myDataGetter = this.myIndexStorage != null ? new IndexDataGetter(this.myProject, this.myRoots, this.myIndexStorage, this.myFatalErrorsConsumer) : null;
        for (VirtualFile root : this.myRoots) {
            this.myNumberOfTasks.put(root, new AtomicInteger());
        }
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    protected IndexStorage createIndexStorage(@NotNull FatalErrorHandler fatalErrorHandler, @NotNull String logId) {
        try {
            return (IndexStorage)IOUtil.openCleanOrResetBroken(() -> new IndexStorage(logId, this.myUserRegistry, this.myRoots, fatalErrorHandler, this), () -> IndexStorage.cleanup(logId));
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return null;
        }
    }

    public static int getVersion() {
        return 6;
    }

    @Override
    public synchronized void scheduleIndex(boolean full) {
        if (this.myCommitsToIndex.isEmpty()) {
            return;
        }
        Map<VirtualFile, TIntHashSet> commitsToIndex = this.myCommitsToIndex;
        for (VirtualFile root : commitsToIndex.keySet()) {
            this.myNumberOfTasks.get(root).incrementAndGet();
        }
        this.myCommitsToIndex = ContainerUtil.newHashMap();
        this.mySingleTaskController.request(new IndexingRequest(commitsToIndex, full));
    }

    private void storeDetail(@NotNull VcsFullCommitDetails detail) {
        if (this.myIndexStorage == null) {
            return;
        }
        try {
            int index = this.myStorage.getCommitIndex((Hash)detail.getId(), detail.getRoot());
            this.myIndexStorage.messages.put((Object)index, (Object)detail.getFullMessage());
            this.myIndexStorage.trigrams.update(index, detail);
            this.myIndexStorage.users.update(index, detail);
            this.myIndexStorage.paths.update(index, detail);
            this.myIndexStorage.commits.put(index);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    private void flush() {
        try {
            if (this.myIndexStorage != null) {
                this.myIndexStorage.messages.force();
                this.myIndexStorage.trigrams.flush();
                this.myIndexStorage.users.flush();
                this.myIndexStorage.paths.flush();
                this.myIndexStorage.commits.flush();
            }
        }
        catch (StorageException e) {
            this.myFatalErrorsConsumer.consume(this, (Exception)((Object)e));
        }
    }

    @Override
    public void markCorrupted() {
        if (this.myIndexStorage != null) {
            this.myIndexStorage.commits.markCorrupted();
        }
    }

    @Override
    public boolean isIndexed(int commit) {
        try {
            return this.myIndexStorage == null || this.myIndexStorage.commits.contains(commit);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return false;
        }
    }

    @Override
    public synchronized boolean isIndexed(@NotNull VirtualFile root) {
        return this.myRoots.contains(root) && !this.myCommitsToIndex.containsKey(root) && this.myNumberOfTasks.get(root).get() == 0;
    }

    @Override
    public synchronized void markForIndexing(int index, @NotNull VirtualFile root) {
        if (this.isIndexed(index) || !this.myRoots.contains(root)) {
            return;
        }
        TIntHashSet set2 = this.myCommitsToIndex.get(root);
        if (set2 == null) {
            set2 = new TIntHashSet();
            this.myCommitsToIndex.put(root, set2);
        }
        set2.add(index);
    }

    @NotNull
    private <T> TIntHashSet filter(@NotNull PersistentMap<Integer, T> map2, @NotNull Condition<T> condition2) {
        TIntHashSet result2 = new TIntHashSet();
        if (this.myIndexStorage == null) {
            return result2;
        }
        try {
            Processor processor2 = integer -> {
                try {
                    Object value2 = map2.get(integer);
                    if (value2 != null && condition2.value(value2)) {
                        result2.add(integer.intValue());
                    }
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    return false;
                }
                return true;
            };
            if (this.myIndexStorage.messages instanceof PersistentHashMap) {
                ((PersistentHashMap)this.myIndexStorage.messages).processKeysWithExistingMapping(processor2);
            } else {
                this.myIndexStorage.messages.processKeys(processor2);
            }
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
        return result2;
    }

    @NotNull
    private TIntHashSet filterUsers(@NotNull Set<VcsUser> users) {
        if (this.myIndexStorage != null) {
            try {
                return this.myIndexStorage.users.getCommitsForUsers(users);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, (Exception)e);
            }
            catch (RuntimeException e) {
                this.processRuntimeException(e);
            }
        }
        return new TIntHashSet();
    }

    @NotNull
    private TIntHashSet filterPaths(@NotNull Collection<FilePath> paths) {
        if (this.myIndexStorage != null) {
            try {
                return this.myIndexStorage.paths.getCommitsForPaths(paths);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, (Exception)e);
            }
            catch (RuntimeException e) {
                this.processRuntimeException(e);
            }
        }
        return new TIntHashSet();
    }

    @NotNull
    public TIntHashSet filterMessages(@NotNull VcsLogTextFilter filter) {
        if (this.myIndexStorage != null) {
            try {
                TIntHashSet commitsForSearch;
                if (!filter.isRegex() && (commitsForSearch = this.myIndexStorage.trigrams.getCommitsForSubstring(filter.getText())) != null) {
                    TIntHashSet result2 = new TIntHashSet();
                    commitsForSearch.forEach(commit -> {
                        try {
                            String value2 = (String)this.myIndexStorage.messages.get((Object)commit);
                            if (value2 != null && VcsLogTextFilterImpl.matches(filter, value2)) {
                                result2.add(commit);
                            }
                        }
                        catch (IOException e) {
                            this.myFatalErrorsConsumer.consume(this, e);
                            return false;
                        }
                        return true;
                    });
                    return result2;
                }
            }
            catch (StorageException e) {
                this.myFatalErrorsConsumer.consume(this, (Exception)((Object)e));
            }
            catch (RuntimeException e) {
                this.processRuntimeException(e);
            }
            return this.filter(this.myIndexStorage.messages, message2 -> VcsLogTextFilterImpl.matches(filter, message2));
        }
        return EmptyIntHashSet.INSTANCE;
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (this.myIndexStorage != null) {
            this.myIndexStorage.markCorrupted();
        }
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            throw new RuntimeException(e);
        }
        this.myFatalErrorsConsumer.consume(this, e);
    }

    @Override
    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters.isEmpty() || this.myIndexStorage == null) {
            return false;
        }
        for (VcsLogDetailsFilter filter : filters) {
            if (filter instanceof VcsLogTextFilter || filter instanceof VcsLogUserFilter || filter instanceof VcsLogStructureFilter) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Set<Integer> filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        TIntHashSet filteredByMessage = null;
        if (textFilter != null) {
            filteredByMessage = this.filterMessages(textFilter);
        }
        TIntHashSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = ContainerUtil.newHashSet();
            for (VirtualFile root : this.myRoots) {
                users.addAll(userFilter.getUsers(root));
            }
            filteredByUser = this.filterUsers(users);
        }
        TIntHashSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        return TroveUtil.intersect(filteredByMessage, filteredByPath, filteredByUser);
    }

    @Override
    @Nullable
    public IndexDataGetter getDataGetter() {
        if (this.myIndexStorage == null) {
            return null;
        }
        return this.myDataGetter;
    }

    @Override
    public void addListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        this.myListeners.add(l);
    }

    @Override
    public void removeListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        this.myListeners.remove(l);
    }

    public void dispose() {
    }

    private static class CommitsCounter {
        @NotNull
        public final ProgressIndicator indicator;
        public final int allCommits;
        public volatile int newIndexedCommits;
        public volatile int oldCommits;

        private CommitsCounter(@NotNull ProgressIndicator indicator, int commits) {
            this.indicator = indicator;
            this.allCommits = commits;
        }

        public void displayProgress() {
            this.indicator.setFraction(((double)this.newIndexedCommits + (double)this.oldCommits) / (double)this.allCommits);
        }
    }

    private class IndexingRequest {
        private static final int MAGIC_NUMBER = 150000;
        private static final int BATCH_SIZE = 1000;
        private final Map<VirtualFile, TIntHashSet> myCommits;
        private final boolean myFull;

        public IndexingRequest(Map<VirtualFile, TIntHashSet> commits, boolean full) {
            this.myCommits = commits;
            this.myFull = full;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            long time = System.currentTimeMillis();
            CommitsCounter counter = new CommitsCounter(indicator, this.myCommits.values().stream().mapToInt(THash::size).sum());
            LOG.debug("Indexing " + counter.allCommits + " commits");
            for (VirtualFile root : this.myCommits.keySet()) {
                try {
                    if (this.myFull) {
                        this.indexAll(root, this.myCommits.get(root), counter);
                    } else {
                        this.indexOneByOne(root, this.myCommits.get(root), counter);
                    }
                }
                finally {
                    ((AtomicInteger)VcsLogPersistentIndex.this.myNumberOfTasks.get(root)).decrementAndGet();
                }
                if (!VcsLogPersistentIndex.this.isIndexed(root)) continue;
                VcsLogPersistentIndex.this.myListeners.forEach(listener2 -> listener2.indexingFinished(root));
            }
            LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - time) + " for indexing " + counter.newIndexedCommits + " new commits out of " + counter.allCommits);
            int leftCommits = counter.allCommits - counter.newIndexedCommits - counter.oldCommits;
            if (leftCommits > 0) {
                LOG.warn("Did not index " + leftCommits + " commits");
            }
        }

        private void indexOneByOne(@NotNull VirtualFile root, @NotNull TIntHashSet commitsSet, @NotNull CommitsCounter counter) {
            IntStream commits = TroveUtil.stream(commitsSet).filter(c -> {
                if (VcsLogPersistentIndex.this.isIndexed(c)) {
                    ++counter.oldCommits;
                    return false;
                }
                return true;
            });
            this.indexOneByOne(root, counter, commits);
        }

        private void indexOneByOne(@NotNull VirtualFile root, @NotNull CommitsCounter counter, @NotNull IntStream commits) {
            TroveUtil.processBatches(commits, 1000, (Consumer<TIntHashSet>)((Consumer)batch -> {
                counter.indicator.checkCanceled();
                if (this.indexOneByOne(root, (TIntHashSet)batch)) {
                    counter.newIndexedCommits += batch.size();
                }
                counter.displayProgress();
            }));
            VcsLogPersistentIndex.this.flush();
        }

        private boolean indexOneByOne(@NotNull VirtualFile root, @NotNull TIntHashSet commits) {
            VcsLogProvider provider2 = (VcsLogProvider)VcsLogPersistentIndex.this.myProviders.get(root);
            try {
                List<String> hashes = TroveUtil.map(commits, value2 -> VcsLogPersistentIndex.this.myStorage.getCommitId(value2).getHash().asString());
                provider2.readFullDetails(root, hashes, x$0 -> VcsLogPersistentIndex.this.storeDetail(x$0));
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
                commits.forEach(value2 -> {
                    VcsLogPersistentIndex.this.markForIndexing(value2, root);
                    return true;
                });
                return false;
            }
            return true;
        }

        public void indexAll(@NotNull VirtualFile root, @NotNull TIntHashSet commitsSet, @NotNull CommitsCounter counter) {
            TIntHashSet notIndexed = new TIntHashSet();
            TroveUtil.stream(commitsSet).forEach(c -> {
                if (VcsLogPersistentIndex.this.isIndexed(c)) {
                    ++counter.oldCommits;
                } else {
                    notIndexed.add(c);
                }
            });
            counter.displayProgress();
            if (notIndexed.size() <= 150000) {
                this.indexOneByOne(root, counter, TroveUtil.stream(notIndexed));
            } else {
                try {
                    ((VcsLogProvider)VcsLogPersistentIndex.this.myProviders.get(root)).readAllFullDetails(root, details -> {
                        int index = VcsLogPersistentIndex.this.myStorage.getCommitIndex((Hash)details.getId(), details.getRoot());
                        if (notIndexed.contains(index)) {
                            VcsLogPersistentIndex.this.storeDetail(details);
                            ++counter.newIndexedCommits;
                        }
                        counter.indicator.checkCanceled();
                        counter.displayProgress();
                    });
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                    notIndexed.forEach(value2 -> {
                        VcsLogPersistentIndex.this.markForIndexing(value2, root);
                        return true;
                    });
                }
            }
            VcsLogPersistentIndex.this.flush();
        }
    }

    private class MySingleTaskController
    extends SingleTaskController<IndexingRequest, Void> {
        public MySingleTaskController() {
            super(EmptyConsumer.getInstance());
        }

        @Override
        protected void startNewBackgroundTask() {
            ApplicationManager.getApplication().invokeLater(() -> {
                Task.Backgroundable task = new Task.Backgroundable(VcsLogPersistentIndex.this.myProject, "Indexing Commit Data", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                    public void run(@NotNull ProgressIndicator indicator) {
                        List requests;
                        while (!(requests = MySingleTaskController.this.popRequests()).isEmpty()) {
                            for (IndexingRequest request : requests) {
                                try {
                                    request.run(indicator);
                                }
                                catch (ProcessCanceledException reThrown) {
                                    throw reThrown;
                                }
                                catch (Throwable t) {
                                    LOG.error("Error while indexing", t);
                                }
                            }
                        }
                        MySingleTaskController.this.taskCompleted(null);
                    }
                };
                ProgressIndicator indicator = VcsLogPersistentIndex.this.myProgress.createProgressIndicator(false);
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, indicator);
            });
        }
    }

    static class IndexStorage {
        private static final String INPUTS = "inputs";
        private static final String COMMITS = "commits";
        private static final String MESSAGES = "messages";
        private static final int MESSAGES_VERSION = 0;
        @NotNull
        public final PersistentSet<Integer> commits;
        @NotNull
        public final PersistentMap<Integer, String> messages;
        @NotNull
        public final VcsLogMessagesTrigramIndex trigrams;
        @NotNull
        public final VcsLogUserIndex users;
        @NotNull
        public final VcsLogPathsIndex paths;

        public IndexStorage(@NotNull String logId, @NotNull VcsUserRegistryImpl userRegistry, @NotNull Set<VirtualFile> roots, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable parentDisposable) throws IOException {
            Disposable disposable = Disposer.newDisposable();
            Disposer.register((Disposable)parentDisposable, (Disposable)disposable);
            try {
                int version = VcsLogPersistentIndex.getVersion();
                File commitsStorage = PersistentUtil.getStorageFile("index", COMMITS, logId, version, true);
                this.commits = new PersistentSetImpl<Integer>(commitsStorage, (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE, Page.PAGE_SIZE, null, version);
                Disposer.register((Disposable)disposable, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::close)));
                File messagesStorage = PersistentUtil.getStorageFile("index", MESSAGES, logId, 5, true);
                this.messages = new PersistentHashMap(messagesStorage, (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)EnumeratorStringDescriptor.INSTANCE, Page.PAGE_SIZE);
                Disposer.register((Disposable)disposable, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.messages.close())));
                this.trigrams = new VcsLogMessagesTrigramIndex(logId, fatalErrorHandler, disposable);
                this.users = new VcsLogUserIndex(logId, userRegistry, fatalErrorHandler, disposable);
                this.paths = new VcsLogPathsIndex(logId, roots, fatalErrorHandler, disposable);
            }
            catch (Throwable t) {
                Disposer.dispose((Disposable)disposable);
                throw t;
            }
            PersistentUtil.cleanupOldStorageFile(MESSAGES, logId);
            PersistentUtil.cleanupOldStorageFile("index-trigrams", logId);
            PersistentUtil.cleanupOldStorageFile("index-no-trigrams", logId);
            PersistentUtil.cleanupOldStorageFile("index-inputs-trigrams", logId);
            PersistentUtil.cleanupOldStorageFile("index-paths", logId);
            PersistentUtil.cleanupOldStorageFile("index-no-paths", logId);
            PersistentUtil.cleanupOldStorageFile("index-paths-ids", logId);
            PersistentUtil.cleanupOldStorageFile("index-inputs-paths", logId);
            PersistentUtil.cleanupOldStorageFile("index-users", logId);
            PersistentUtil.cleanupOldStorageFile("index-inputs-users", logId);
        }

        void markCorrupted() {
            IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::markCorrupted));
        }

        private static void catchAndWarn(@NotNull ThrowableRunnable<IOException> runnable2) {
            try {
                runnable2.run();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        private static void cleanup(@NotNull String logId) {
            if (!PersistentUtil.cleanupStorageFiles("index", logId)) {
                LOG.error("Could not clean up storage files in " + new File(PersistentUtil.LOG_CACHE, "index") + " starting with " + logId);
            }
        }
    }
}

