/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogUserIndex
extends VcsLogFullDetailsIndex<Void> {
    private static final Logger LOG = Logger.getInstance(VcsLogUserIndex.class);
    public static final String USERS = "users";
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;

    public VcsLogUserIndex(@NotNull String logId, @NotNull VcsUserRegistryImpl userRegistry, @NotNull FatalErrorHandler consumer2, @NotNull Disposable disposableParent) throws IOException {
        super(logId, USERS, VcsLogPersistentIndex.getVersion(), new UserIndexer(userRegistry), VoidDataExternalizer.INSTANCE, consumer2, disposableParent);
        this.myUserRegistry = userRegistry;
        ((UserIndexer)this.myIndexer).setFatalErrorConsumer((Consumer<Exception>)((Consumer)e -> consumer2.consume(this, (Exception)e)));
    }

    public TIntHashSet getCommitsForUsers(@NotNull Set<VcsUser> users) throws IOException, StorageException {
        HashSet ids = ContainerUtil.newHashSet();
        for (VcsUser user : users) {
            ids.add(this.myUserRegistry.getUserId(user));
        }
        return this.getCommitsWithAnyKey(ids);
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    private static class UserIndexer
    implements DataIndexer<Integer, Void, VcsFullCommitDetails> {
        @NotNull
        private final VcsUserRegistryImpl myRegistry;
        @NotNull
        private Consumer<Exception> myFatalErrorConsumer = arg_0 -> ((Logger)VcsLogUserIndex.access$000()).error(arg_0);

        public UserIndexer(@NotNull VcsUserRegistryImpl registry) {
            this.myRegistry = registry;
        }

        @NotNull
        public Map<Integer, Void> map(@NotNull VcsFullCommitDetails inputData) {
            THashMap result2 = new THashMap();
            try {
                result2.put(this.myRegistry.getUserId(inputData.getAuthor()), null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
            return result2;
        }

        public void setFatalErrorConsumer(@NotNull Consumer<Exception> fatalErrorConsumer) {
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }
    }
}

