/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.elements.GraphNodeType;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.bek.BekChecker;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BekBaseController
extends CascadeController {
    @NotNull
    private final BekIntMap myBekIntMap;
    @NotNull
    private final LinearGraph myBekGraph;

    public BekBaseController(@NotNull PermanentGraphInfo permanentGraphInfo, @NotNull BekIntMap bekIntMap) {
        super(null, permanentGraphInfo);
        this.myBekIntMap = bekIntMap;
        this.myBekGraph = new BekLinearGraph(this.myBekIntMap, this.myPermanentGraphInfo.getLinearGraph());
        BekChecker.checkLinearGraph(this.myBekGraph);
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        throw new IllegalStateException();
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        return null;
    }

    @NotNull
    public BekIntMap getBekIntMap() {
        return this.myBekIntMap;
    }

    @Override
    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        if (graphElement instanceof GraphEdge) {
            Integer upIndex = ((GraphEdge)graphElement).getUpNodeIndex();
            Integer downIndex = ((GraphEdge)graphElement).getDownNodeIndex();
            Integer convertedUpIndex = upIndex == null ? null : Integer.valueOf(this.myBekIntMap.getUsualIndex(upIndex));
            Integer convertedDownIndex = downIndex == null ? null : Integer.valueOf(this.myBekIntMap.getUsualIndex(downIndex));
            return new GraphEdge(convertedUpIndex, convertedDownIndex, ((GraphEdge)graphElement).getTargetId(), ((GraphEdge)graphElement).getType());
        }
        if (graphElement instanceof GraphNode) {
            return new GraphNode(this.myBekIntMap.getUsualIndex(((GraphNode)graphElement).getNodeIndex()), ((GraphNode)graphElement).getType());
        }
        return null;
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        return this.myBekGraph;
    }

    public static class BekLinearGraph
    implements LinearGraph {
        @NotNull
        private final LinearGraph myLinearGraph;
        @NotNull
        private final BekIntMap myBekIntMap;

        public BekLinearGraph(@NotNull BekIntMap bekIntMap, @NotNull LinearGraph linearGraph) {
            this.myLinearGraph = linearGraph;
            this.myBekIntMap = bekIntMap;
        }

        @Override
        public int nodesCount() {
            return this.myLinearGraph.nodesCount();
        }

        @Nullable
        private Integer getNodeIndex(@Nullable Integer nodeId) {
            if (nodeId == null) {
                return null;
            }
            return this.myBekIntMap.getBekIndex(nodeId);
        }

        @Override
        @NotNull
        public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter) {
            return ContainerUtil.map(this.myLinearGraph.getAdjacentEdges(this.myBekIntMap.getUsualIndex(nodeIndex), filter), (Function)new Function<GraphEdge, GraphEdge>(){

                public GraphEdge fun(GraphEdge edge) {
                    return new GraphEdge(this.getNodeIndex(edge.getUpNodeIndex()), this.getNodeIndex(edge.getDownNodeIndex()), edge.getTargetId(), edge.getType());
                }
            });
        }

        @Override
        @NotNull
        public GraphNode getGraphNode(int nodeIndex) {
            assert (this.inRanges(nodeIndex));
            return new GraphNode(nodeIndex, GraphNodeType.USUAL);
        }

        @Override
        public int getNodeId(int nodeIndex) {
            return this.myBekIntMap.getUsualIndex(nodeIndex);
        }

        @Override
        @Nullable
        public Integer getNodeIndex(int nodeId) {
            if (!this.inRanges(nodeId)) {
                return null;
            }
            return this.myBekIntMap.getBekIndex(nodeId);
        }

        private boolean inRanges(int index) {
            return index >= 0 && index < this.nodesCount();
        }
    }
}

