/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GraphChanges<NodeId> {
    @NotNull
    public Collection<Node<NodeId>> getChangedNodes();

    @NotNull
    public Collection<Edge<NodeId>> getChangedEdges();

    public static class GraphChangesImpl<NodeId>
    implements GraphChanges<NodeId> {
        private final Collection<Node<NodeId>> myChangedNodes;
        private final Collection<Edge<NodeId>> myChangedEdges;

        public GraphChangesImpl(Collection<Node<NodeId>> changedNodes, Collection<Edge<NodeId>> changedEdges) {
            this.myChangedNodes = changedNodes;
            this.myChangedEdges = changedEdges;
        }

        @Override
        @NotNull
        public Collection<Node<NodeId>> getChangedNodes() {
            return this.myChangedNodes;
        }

        @Override
        @NotNull
        public Collection<Edge<NodeId>> getChangedEdges() {
            return this.myChangedEdges;
        }
    }

    public static class EdgeImpl<NodeId>
    implements Edge<NodeId> {
        @Nullable
        private final NodeId myUpNodeId;
        @Nullable
        private final NodeId myDownNodeId;
        @Nullable
        private final NodeId myTargetId;
        private final boolean myRemoved;

        public EdgeImpl(@Nullable NodeId upNodeId, @Nullable NodeId downNodeId, @Nullable NodeId targetId, boolean removed) {
            this.myUpNodeId = upNodeId;
            this.myDownNodeId = downNodeId;
            this.myTargetId = targetId;
            this.myRemoved = removed;
        }

        @Override
        @Nullable
        public NodeId upNodeId() {
            return this.myUpNodeId;
        }

        @Override
        @Nullable
        public NodeId downNodeId() {
            return this.myDownNodeId;
        }

        @Override
        @Nullable
        public NodeId targetId() {
            return this.myTargetId;
        }

        @Override
        public boolean removed() {
            return this.myRemoved;
        }
    }

    public static class NodeImpl<NodeId>
    implements Node<NodeId> {
        @NotNull
        private final NodeId myNodeId;
        private final boolean myRemoved;

        public NodeImpl(@NotNull NodeId nodeId, boolean removed) {
            this.myNodeId = nodeId;
            this.myRemoved = removed;
        }

        @Override
        @NotNull
        public NodeId getNodeId() {
            return this.myNodeId;
        }

        @Override
        public boolean removed() {
            return this.myRemoved;
        }
    }

    public static interface Edge<NodeId> {
        @Nullable
        public NodeId upNodeId();

        @Nullable
        public NodeId downNodeId();

        @Nullable
        public NodeId targetId();

        public boolean removed();
    }

    public static interface Node<NodeId> {
        @NotNull
        public NodeId getNodeId();

        public boolean removed();
    }
}

