/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.BranchFilterController;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.BekBaseController;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.FilteredController;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.facade.bek.BekSorter;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutBuilder;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.linearBek.LinearBekController;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermanentGraphImpl<CommitId>
implements PermanentGraph<CommitId>,
PermanentGraphInfo<CommitId> {
    @NotNull
    private final PermanentCommitsInfoImpl<CommitId> myPermanentCommitsInfo;
    @NotNull
    private final PermanentLinearGraphImpl myPermanentLinearGraph;
    @NotNull
    private final GraphLayoutImpl myPermanentGraphLayout;
    @NotNull
    private final GraphColorManager<CommitId> myGraphColorManager;
    @NotNull
    private final Set<Integer> myBranchNodeIds;
    @NotNull
    private final ReachableNodes myReachableNodes;
    @NotNull
    private final Supplier<BekIntMap> myBekIntMap;

    @NotNull
    public static <CommitId> PermanentGraphImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, final @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<CommitId> branchesCommitId) {
        PermanentLinearGraphBuilder permanentLinearGraphBuilder = PermanentLinearGraphBuilder.newInstance(graphCommits);
        NotLoadedCommitsIdsGenerator idsGenerator = new NotLoadedCommitsIdsGenerator();
        PermanentLinearGraphImpl linearGraph = permanentLinearGraphBuilder.build(idsGenerator);
        final PermanentCommitsInfoImpl commitIdPermanentCommitsInfo = PermanentCommitsInfoImpl.newInstance(graphCommits, idsGenerator.getNotLoadedCommits());
        GraphLayoutImpl permanentGraphLayout = GraphLayoutBuilder.build(linearGraph, new Comparator<Integer>(){

            @Override
            public int compare(@NotNull Integer nodeIndex1, @NotNull Integer nodeIndex2) {
                Object commitId1 = commitIdPermanentCommitsInfo.getCommitId(nodeIndex1);
                Object commitId2 = commitIdPermanentCommitsInfo.getCommitId(nodeIndex2);
                return graphColorManager.compareHeads(commitId2, commitId1);
            }
        });
        return new PermanentGraphImpl(linearGraph, permanentGraphLayout, commitIdPermanentCommitsInfo, graphColorManager, branchesCommitId);
    }

    public PermanentGraphImpl(@NotNull PermanentLinearGraphImpl permanentLinearGraph, @NotNull GraphLayoutImpl permanentGraphLayout, @NotNull PermanentCommitsInfoImpl<CommitId> permanentCommitsInfo, @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<CommitId> branchesCommitId) {
        this.myPermanentGraphLayout = permanentGraphLayout;
        this.myPermanentCommitsInfo = permanentCommitsInfo;
        this.myPermanentLinearGraph = permanentLinearGraph;
        this.myGraphColorManager = graphColorManager;
        this.myBranchNodeIds = permanentCommitsInfo.convertToNodeIds(branchesCommitId);
        this.myReachableNodes = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentLinearGraph));
        this.myBekIntMap = Suppliers.memoize((Supplier)new Supplier<BekIntMap>(){

            public BekIntMap get() {
                return BekSorter.createBekMap(PermanentGraphImpl.this.myPermanentLinearGraph, PermanentGraphImpl.this.myPermanentGraphLayout, PermanentGraphImpl.this.myPermanentCommitsInfo.getTimestampGetter());
            }
        });
    }

    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<CommitId> visibleHeads, @Nullable Set<CommitId> matchingCommits) {
        CascadeController controller;
        CascadeController baseController = sortType == PermanentGraph.SortType.Normal ? new BaseController(this) : (sortType == PermanentGraph.SortType.LinearBek ? new LinearBekController(new BekBaseController(this, (BekIntMap)this.myBekIntMap.get()), (PermanentGraphInfo)this) : new BekBaseController(this, (BekIntMap)this.myBekIntMap.get()));
        if (matchingCommits != null) {
            controller = new FilteredController(baseController, this, this.myPermanentCommitsInfo.convertToNodeIds(matchingCommits));
            if (visibleHeads != null) {
                controller = new BranchFilterController(controller, this, this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads, true));
            }
        } else if (sortType == PermanentGraph.SortType.LinearBek) {
            controller = visibleHeads != null ? new BranchFilterController(baseController, this, this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads, true)) : baseController;
        } else {
            Set<Integer> idOfVisibleBranches = null;
            if (visibleHeads != null) {
                idOfVisibleBranches = this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads, true);
            }
            controller = new CollapsedController(baseController, this, idOfVisibleBranches);
        }
        return new VisibleGraphImpl<CommitId>(controller, this, this.myGraphColorManager);
    }

    @NotNull
    public List<GraphCommit<CommitId>> getAllCommits() {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (int index = 0; index < this.myPermanentLinearGraph.nodesCount(); ++index) {
            CommitId commitId = this.myPermanentCommitsInfo.getCommitId(index);
            List<Integer> downNodes = LinearGraphUtils.getDownNodesIncludeNotLoad(this.myPermanentLinearGraph, index);
            List<CommitId> parentsCommitIds = this.myPermanentCommitsInfo.convertToCommitIdList(downNodes);
            GraphCommitImpl<CommitId> graphCommit = new GraphCommitImpl<CommitId>(commitId, parentsCommitIds, this.myPermanentCommitsInfo.getTimestamp(index));
            result2.add(graphCommit);
        }
        return result2;
    }

    @NotNull
    public List<CommitId> getChildren(@NotNull CommitId commit) {
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit);
        return this.myPermanentCommitsInfo.convertToCommitIdList(LinearGraphUtils.getUpNodes(this.myPermanentLinearGraph, commitIndex));
    }

    @NotNull
    public Set<CommitId> getContainingBranches(@NotNull CommitId commit) {
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit);
        return this.myPermanentCommitsInfo.convertToCommitIdSet(this.myReachableNodes.getContainingBranches(commitIndex, this.myBranchNodeIds));
    }

    @NotNull
    public Condition<CommitId> getContainedInBranchCondition(@NotNull Collection<CommitId> heads) {
        List headIds = ContainerUtil.map(heads, (Function)new Function<CommitId, Integer>(){

            public Integer fun(CommitId head) {
                return PermanentGraphImpl.this.myPermanentCommitsInfo.getNodeId(head);
            }
        });
        if (!heads.isEmpty() && ContainerUtil.getFirstItem(heads) instanceof Integer) {
            final TIntHashSet branchNodes = new TIntHashSet();
            this.myReachableNodes.walk(headIds, new Consumer<Integer>(){

                public void consume(Integer node) {
                    branchNodes.add(((Integer)PermanentGraphImpl.this.myPermanentCommitsInfo.getCommitId(node)).intValue());
                }
            });
            return new IntContainedInBranchCondition(branchNodes);
        }
        final HashSet branchNodes = ContainerUtil.newHashSet();
        this.myReachableNodes.walk(headIds, new Consumer<Integer>(){

            public void consume(Integer node) {
                branchNodes.add(PermanentGraphImpl.this.myPermanentCommitsInfo.getCommitId(node));
            }
        });
        return new ContainedInBranchCondition(branchNodes);
    }

    @Override
    @NotNull
    public PermanentCommitsInfoImpl<CommitId> getPermanentCommitsInfo() {
        return this.myPermanentCommitsInfo;
    }

    @Override
    @NotNull
    public PermanentLinearGraphImpl getLinearGraph() {
        return this.myPermanentLinearGraph;
    }

    @Override
    @NotNull
    public GraphLayoutImpl getPermanentGraphLayout() {
        return this.myPermanentGraphLayout;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        return this.myBranchNodeIds;
    }

    private static class ContainedInBranchCondition<CommitId>
    implements Condition<CommitId> {
        private final Set<CommitId> myBranchNodes;

        public ContainedInBranchCondition(Set<CommitId> branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        public boolean value(CommitId commitId) {
            return this.myBranchNodes.contains(commitId);
        }
    }

    private static class IntContainedInBranchCondition<CommitId>
    implements Condition<CommitId> {
        private final TIntHashSet myBranchNodes;

        public IntContainedInBranchCondition(TIntHashSet branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        public boolean value(CommitId commitId) {
            return this.myBranchNodes.contains(((Integer)commitId).intValue());
        }
    }

    private static class NotLoadedCommitsIdsGenerator<CommitId>
    implements NotNullFunction<CommitId, Integer> {
        @NotNull
        private final Map<Integer, CommitId> myNotLoadedCommits = ContainerUtil.newHashMap();

        private NotLoadedCommitsIdsGenerator() {
        }

        @NotNull
        public Integer fun(CommitId dom) {
            int nodeId = -(this.myNotLoadedCommits.size() + 2);
            this.myNotLoadedCommits.put(nodeId, dom);
            return nodeId;
        }

        @NotNull
        public Map<Integer, CommitId> getNotLoadedCommits() {
            return this.myNotLoadedCommits;
        }
    }
}

