/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.NotNullFunction;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.ColorGetterByLayoutIndex;
import com.intellij.vcs.log.graph.impl.print.GraphElementComparatorByLayoutIndex;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PrintElementManagerImpl
implements PrintElementManager {
    @NotNull
    private final Comparator<GraphElement> myGraphElementComparator;
    @NotNull
    private final ColorGetterByLayoutIndex myColorGetter;
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private Set<Integer> mySelectedNodeIds = Collections.emptySet();
    @Nullable
    private PrintElementWithGraphElement mySelectedPrintElement = null;

    PrintElementManagerImpl(@NotNull LinearGraph linearGraph, @NotNull PermanentGraphInfo myPermanentGraph, @NotNull GraphColorManager colorManager) {
        this.myLinearGraph = linearGraph;
        this.myColorGetter = new ColorGetterByLayoutIndex(linearGraph, myPermanentGraph, colorManager);
        this.myGraphElementComparator = new GraphElementComparatorByLayoutIndex((NotNullFunction<Integer, Integer>)((NotNullFunction)nodeIndex -> {
            int nodeId = linearGraph.getNodeId((int)nodeIndex);
            if (nodeId < 0) {
                return nodeId;
            }
            return myPermanentGraph.getPermanentGraphLayout().getLayoutIndex(nodeId);
        }));
    }

    @Override
    public boolean isSelected(@NotNull PrintElementWithGraphElement printElement) {
        if (printElement.equals(this.mySelectedPrintElement)) {
            return true;
        }
        GraphElement graphElement = printElement.getGraphElement();
        if (graphElement instanceof GraphNode) {
            int nodeId = this.myLinearGraph.getNodeId(((GraphNode)graphElement).getNodeIndex());
            return this.mySelectedNodeIds.contains(nodeId);
        }
        if (graphElement instanceof GraphEdge) {
            GraphEdge edge = (GraphEdge)graphElement;
            boolean selected = edge.getTargetId() == null || this.mySelectedNodeIds.contains(edge.getTargetId());
            selected &= edge.getUpNodeIndex() == null || this.mySelectedNodeIds.contains(this.myLinearGraph.getNodeId(edge.getUpNodeIndex()));
            return selected &= edge.getDownNodeIndex() == null || this.mySelectedNodeIds.contains(this.myLinearGraph.getNodeId(edge.getDownNodeIndex()));
        }
        return false;
    }

    void setSelectedElement(@NotNull PrintElementWithGraphElement printElement) {
        this.mySelectedNodeIds = Collections.emptySet();
        this.mySelectedPrintElement = printElement;
    }

    void setSelectedElements(@NotNull Set<Integer> selectedNodeId) {
        this.mySelectedPrintElement = null;
        this.mySelectedNodeIds = selectedNodeId;
    }

    @Override
    public int getColorId(@NotNull GraphElement element) {
        return this.myColorGetter.getColorId(element);
    }

    @Override
    @NotNull
    public Comparator<GraphElement> getGraphElementComparator() {
        return this.myGraphElementComparator;
    }
}

