/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.Consumer;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReachableNodes {
    @NotNull
    private final LiteLinearGraph myGraph;
    @NotNull
    private final Flags myTempFlags;

    public ReachableNodes(@NotNull LiteLinearGraph graph) {
        this.myGraph = graph;
        this.myTempFlags = new BitSetFlags(graph.nodesCount());
    }

    @NotNull
    public static UnsignedBitSet getReachableNodes(@NotNull LinearGraph permanentGraph, @Nullable Set<Integer> headNodeIndexes) {
        if (headNodeIndexes == null) {
            UnsignedBitSet nodesVisibility = new UnsignedBitSet();
            nodesVisibility.set(0, permanentGraph.nodesCount() - 1, true);
            return nodesVisibility;
        }
        UnsignedBitSet result2 = new UnsignedBitSet();
        ReachableNodes getter = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentGraph));
        getter.walk(headNodeIndexes, (Consumer<Integer>)((Consumer)node -> result2.set((int)node, true)));
        return result2;
    }

    @NotNull
    public Set<Integer> getContainingBranches(int nodeIndex, @NotNull Collection<Integer> branchNodeIndexes) {
        HashSet<Integer> result2 = new HashSet<Integer>();
        this.walk(Collections.singletonList(nodeIndex), false, (Consumer<Integer>)((Consumer)node -> {
            if (branchNodeIndexes.contains(node)) {
                result2.add((Integer)node);
            }
        }));
        return result2;
    }

    public void walk(@NotNull Collection<Integer> headIds, @NotNull Consumer<Integer> consumer2) {
        this.walk(headIds, true, consumer2);
    }

    private void walk(@NotNull Collection<Integer> startNodes, boolean goDown, @NotNull Consumer<Integer> consumer2) {
        this.walk(startNodes, goDown, (int node) -> {
            consumer2.consume((Object)node);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walk(@NotNull Collection<Integer> startNodes, boolean goDown, @NotNull IntPredicate consumer2) {
        Flags flags = this.myTempFlags;
        synchronized (flags) {
            this.myTempFlags.setAll(false);
            for (int start : startNodes) {
                if (start < 0 || this.myTempFlags.get(start)) continue;
                this.myTempFlags.set(start, true);
                if (!consumer2.test(start)) {
                    return;
                }
                DfsUtil.walk(start, currentNode -> {
                    for (int downNode : this.myGraph.getNodes(currentNode, goDown ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP)) {
                        if (this.myTempFlags.get(downNode)) continue;
                        this.myTempFlags.set(downNode, true);
                        if (!consumer2.test(downNode)) {
                            return -10;
                        }
                        return downNode;
                    }
                    return -1;
                });
            }
        }
    }
}

