/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import com.intellij.vcs.log.graph.utils.impl.IntTimestampGetter;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SimpleGraphInfo<CommitId>
implements PermanentGraphInfo<CommitId> {
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private final GraphLayout myGraphLayout;
    @NotNull
    private final NotNullFunction<Integer, CommitId> myFunction;
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final Set<Integer> myBranchNodeIds;

    private SimpleGraphInfo(@NotNull LinearGraph linearGraph, @NotNull GraphLayout graphLayout, @NotNull NotNullFunction<Integer, CommitId> function, @NotNull TimestampGetter timestampGetter, @NotNull Set<Integer> branchNodeIds) {
        this.myLinearGraph = linearGraph;
        this.myGraphLayout = graphLayout;
        this.myFunction = function;
        this.myTimestampGetter = timestampGetter;
        this.myBranchNodeIds = branchNodeIds;
    }

    public static <CommitId> SimpleGraphInfo<CommitId> build(@NotNull LinearGraph linearGraph, @NotNull GraphLayout oldLayout, @NotNull PermanentCommitsInfo<CommitId> permanentCommitsInfo, int permanentGraphSize, @NotNull Set<Integer> branchNodeIds) {
        int firstVisibleRow = 1000;
        int delta = 1000;
        int start = Math.max(0, firstVisibleRow - delta);
        int end = Math.min(linearGraph.nodesCount(), start + 2 * delta);
        ArrayList graphCommits = ContainerUtil.newArrayListWithCapacity((int)(end - start));
        ArrayList commitsIdMap = ContainerUtil.newArrayListWithCapacity((int)(end - start));
        for (int row = start; row < end; ++row) {
            int nodeId = linearGraph.getNodeId(row);
            CommitId commit = permanentCommitsInfo.getCommitId(nodeId);
            List parents = ContainerUtil.newSmartList();
            parents.addAll(ContainerUtil.mapNotNull(LinearGraphUtils.asLiteLinearGraph(linearGraph).getNodes(row, LiteLinearGraph.NodeFilter.DOWN), row1 -> {
                if (row1 < start || row1 >= end) {
                    return null;
                }
                return permanentCommitsInfo.getCommitId(linearGraph.getNodeId((int)row1));
            }));
            graphCommits.add(new GraphCommitImpl<CommitId>(commit, parents, permanentCommitsInfo.getTimestamp(nodeId)));
            commitsIdMap.add(commit);
        }
        IntTimestampGetter timestampGetter = PermanentCommitsInfoImpl.createTimestampGetter(graphCommits);
        NotNullFunction<Integer, CommitId> function = SimpleGraphInfo.createCommitIdMapFunction(commitsIdMap);
        PermanentLinearGraphImpl newLinearGraph = PermanentLinearGraphBuilder.newInstance(graphCommits).build();
        int[] layoutIndexes = new int[end - start];
        ArrayList headNodeIndexes = ContainerUtil.newArrayList();
        TObjectIntHashMap<CommitId> commitIdToInteger = SimpleGraphInfo.reverseCommitIdMap(permanentCommitsInfo, permanentGraphSize);
        for (int row = start; row < end; ++row) {
            int layoutIndex;
            Object commitId = commitsIdMap.get(row - start);
            layoutIndexes[row - start] = layoutIndex = oldLayout.getLayoutIndex(commitIdToInteger.get(commitId));
            if (!LinearGraphUtils.asLiteLinearGraph(newLinearGraph).getNodes(row - start, LiteLinearGraph.NodeFilter.UP).isEmpty()) continue;
            headNodeIndexes.add(row - start);
        }
        ContainerUtil.sort((List)headNodeIndexes, Comparator.comparingInt(o -> layoutIndexes[o]));
        int[] starts = new int[headNodeIndexes.size()];
        for (int i2 = 0; i2 < starts.length; ++i2) {
            starts[i2] = layoutIndexes[(Integer)headNodeIndexes.get(i2)];
        }
        GraphLayoutImpl newLayout = new GraphLayoutImpl(layoutIndexes, headNodeIndexes, starts);
        return new SimpleGraphInfo<CommitId>(newLinearGraph, newLayout, function, timestampGetter, LinearGraphUtils.convertIdsToNodeIndexes(linearGraph, branchNodeIds));
    }

    @NotNull
    private static <CommitId> NotNullFunction<Integer, CommitId> createCommitIdMapFunction(List<CommitId> commitsIdMap) {
        Object function;
        if (!commitsIdMap.isEmpty() && commitsIdMap.get(0) instanceof Integer) {
            int[] ints = new int[commitsIdMap.size()];
            for (int row = 0; row < commitsIdMap.size(); ++row) {
                ints[row] = (Integer)commitsIdMap.get(row);
            }
            function = new IntegerCommitIdMapFunction(CompressedIntList.newInstance(ints));
        } else {
            function = new CommitIdMapFunction<CommitId>(commitsIdMap);
        }
        return function;
    }

    @NotNull
    private static <CommitId> TObjectIntHashMap<CommitId> reverseCommitIdMap(PermanentCommitsInfo<CommitId> permanentCommitsInfo, int size) {
        TObjectIntHashMap result2 = new TObjectIntHashMap();
        for (int i2 = 0; i2 < size; ++i2) {
            result2.put(permanentCommitsInfo.getCommitId(i2), i2);
        }
        return result2;
    }

    @Override
    @NotNull
    public PermanentCommitsInfo<CommitId> getPermanentCommitsInfo() {
        return new PermanentCommitsInfo<CommitId>(){

            @Override
            @NotNull
            public CommitId getCommitId(int nodeId) {
                return SimpleGraphInfo.this.myFunction.fun((Object)nodeId);
            }

            @Override
            public long getTimestamp(int nodeId) {
                return SimpleGraphInfo.this.myTimestampGetter.getTimestamp(nodeId);
            }

            @Override
            public int getNodeId(@NotNull CommitId commitId) {
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!SimpleGraphInfo.this.myFunction.fun((Object)id).equals(commitId)) continue;
                    return id;
                }
                return -1;
            }

            @Override
            @NotNull
            public Set<Integer> convertToNodeIds(@NotNull Collection<CommitId> heads) {
                HashSet result2 = ContainerUtil.newHashSet();
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!heads.contains(SimpleGraphInfo.this.myFunction.fun((Object)id))) continue;
                    result2.add(id);
                }
                return result2;
            }
        };
    }

    @Override
    @NotNull
    public LinearGraph getLinearGraph() {
        return this.myLinearGraph;
    }

    @Override
    @NotNull
    public GraphLayout getPermanentGraphLayout() {
        return this.myGraphLayout;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        return this.myBranchNodeIds;
    }

    private static class IntegerCommitIdMapFunction
    implements NotNullFunction<Integer, Integer> {
        private final IntList myCommitsIdMap;

        public IntegerCommitIdMapFunction(IntList commitsIdMap) {
            this.myCommitsIdMap = commitsIdMap;
        }

        @NotNull
        public Integer fun(Integer dom) {
            return this.myCommitsIdMap.get(dom);
        }
    }

    private static class CommitIdMapFunction<CommitId>
    implements NotNullFunction<Integer, CommitId> {
        private final List<CommitId> myCommitsIdMap;

        public CommitIdMapFunction(List<CommitId> commitsIdMap) {
            this.myCommitsIdMap = commitsIdMap;
        }

        @NotNull
        public CommitId fun(Integer dom) {
            return this.myCommitsIdMap.get(dom);
        }
    }
}

