/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranch;
import com.intellij.vcs.log.graph.impl.facade.bek.BekEdgeRestrictions;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class BekBranchCreator {
    @NotNull
    private final LinearGraph myPermanentGraph;
    @NotNull
    private final GraphLayoutImpl myGraphLayout;
    @NotNull
    private final Flags myDoneNodes;
    @NotNull
    private final BekEdgeRestrictions myEdgeRestrictions = new BekEdgeRestrictions();

    public BekBranchCreator(@NotNull LinearGraph permanentGraph, @NotNull GraphLayoutImpl graphLayout) {
        this.myPermanentGraph = permanentGraph;
        this.myGraphLayout = graphLayout;
        this.myDoneNodes = new BitSetFlags(permanentGraph.nodesCount(), false);
    }

    @NotNull
    public Pair<List<BekBranch>, BekEdgeRestrictions> getResult() {
        ArrayList bekBranches = ContainerUtil.newArrayList();
        for (int headNode : this.myGraphLayout.getHeadNodeIndex()) {
            List<Integer> nextBranch = this.createNextBranch(headNode);
            bekBranches.add(new BekBranch(this.myPermanentGraph, nextBranch));
        }
        return Pair.create((Object)bekBranches, (Object)this.myEdgeRestrictions);
    }

    public List<Integer> createNextBranch(int headNode) {
        final ArrayList nodeIndexes = ContainerUtil.newArrayList();
        assert (!this.myDoneNodes.get(headNode));
        this.myDoneNodes.set(headNode, true);
        nodeIndexes.add(headNode);
        final int startLayout = this.myGraphLayout.getLayoutIndex(headNode);
        DfsUtil.walk(headNode, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                int currentLayout = BekBranchCreator.this.myGraphLayout.getLayoutIndex(currentNode);
                List<Integer> downNodes = LinearGraphUtils.getDownNodes(BekBranchCreator.this.myPermanentGraph, currentNode);
                for (int i2 = downNodes.size() - 1; i2 >= 0; --i2) {
                    int downNode = downNodes.get(i2);
                    if (BekBranchCreator.this.myDoneNodes.get(downNode)) {
                        if (BekBranchCreator.this.myGraphLayout.getLayoutIndex(downNode) >= startLayout) continue;
                        BekBranchCreator.this.myEdgeRestrictions.addRestriction(currentNode, downNode);
                        continue;
                    }
                    if (currentLayout > BekBranchCreator.this.myGraphLayout.getLayoutIndex(downNode)) continue;
                    boolean hasUndoneUpNodes = false;
                    for (int upNode : LinearGraphUtils.getUpNodes(BekBranchCreator.this.myPermanentGraph, downNode)) {
                        if (BekBranchCreator.this.myDoneNodes.get(upNode) || BekBranchCreator.this.myGraphLayout.getLayoutIndex(upNode) > BekBranchCreator.this.myGraphLayout.getLayoutIndex(downNode)) continue;
                        hasUndoneUpNodes = true;
                        break;
                    }
                    if (hasUndoneUpNodes) continue;
                    BekBranchCreator.this.myDoneNodes.set(downNode, true);
                    nodeIndexes.add(downNode);
                    return downNode;
                }
                return -1;
            }
        });
        return nodeIndexes;
    }
}

