/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import com.intellij.vcs.log.graph.utils.impl.IntTimestampGetter;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PermanentCommitsInfoImpl<CommitId>
implements PermanentCommitsInfo<CommitId> {
    private static final Logger LOG = Logger.getInstance(PermanentCommitsInfoImpl.class);
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final List<CommitId> myCommitIdIndexes;
    @NotNull
    private final Map<Integer, CommitId> myNotLoadCommits;

    @NotNull
    public static <CommitId> PermanentCommitsInfoImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, @NotNull Map<Integer, CommitId> notLoadedCommits) {
        IntTimestampGetter timestampGetter = PermanentCommitsInfoImpl.createTimestampGetter(graphCommits);
        boolean isIntegerCase = !graphCommits.isEmpty() && graphCommits.get(0).getId().getClass() == Integer.class;
        List commitIdIndex = isIntegerCase ? PermanentCommitsInfoImpl.createCompressedIntList(graphCommits) : ContainerUtil.map(graphCommits, (Function)new Function<GraphCommit<CommitId>, CommitId>(){

            public CommitId fun(GraphCommit<CommitId> graphCommit) {
                return graphCommit.getId();
            }
        });
        return new PermanentCommitsInfoImpl<CommitId>(timestampGetter, commitIdIndex, notLoadedCommits);
    }

    @NotNull
    public static <CommitId> IntTimestampGetter createTimestampGetter(final @NotNull List<? extends GraphCommit<CommitId>> graphCommits) {
        return IntTimestampGetter.newInstance(new TimestampGetter(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public long getTimestamp(int index) {
                return ((GraphCommit)graphCommits.get(index)).getTimestamp();
            }
        });
    }

    @NotNull
    private static List<Integer> createCompressedIntList(final @NotNull List<? extends GraphCommit<Integer>> graphCommits) {
        final IntList compressedIntList = CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public int get(int index) {
                return (Integer)((GraphCommit)graphCommits.get(index)).getId();
            }
        }, 30);
        return new AbstractList<Integer>(){

            @Override
            @NotNull
            public Integer get(int index) {
                return compressedIntList.get(index);
            }

            @Override
            public int size() {
                return compressedIntList.size();
            }
        };
    }

    public PermanentCommitsInfoImpl(@NotNull TimestampGetter timestampGetter, @NotNull List<CommitId> commitIdIndex, @NotNull Map<Integer, CommitId> notLoadCommits) {
        this.myTimestampGetter = timestampGetter;
        this.myCommitIdIndexes = commitIdIndex;
        this.myNotLoadCommits = notLoadCommits;
    }

    @Override
    @NotNull
    public CommitId getCommitId(int nodeId) {
        if (nodeId < 0) {
            return this.myNotLoadCommits.get(nodeId);
        }
        return this.myCommitIdIndexes.get(nodeId);
    }

    @Override
    public long getTimestamp(int nodeId) {
        if (nodeId < 0) {
            return 0L;
        }
        return this.myTimestampGetter.getTimestamp(nodeId);
    }

    @NotNull
    public TimestampGetter getTimestampGetter() {
        return this.myTimestampGetter;
    }

    @Override
    public int getNodeId(@NotNull CommitId commitId) {
        int indexOf = this.myCommitIdIndexes.indexOf(commitId);
        if (indexOf != -1) {
            return indexOf;
        }
        return this.getNotLoadNodeId(commitId);
    }

    private int getNotLoadNodeId(@NotNull CommitId commitId) {
        for (Map.Entry<Integer, CommitId> entry : this.myNotLoadCommits.entrySet()) {
            if (!entry.getValue().equals(commitId)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @NotNull
    public List<CommitId> convertToCommitIdList(@NotNull Collection<Integer> commitIndexes) {
        return ContainerUtil.map(commitIndexes, (Function)new Function<Integer, CommitId>(){

            public CommitId fun(Integer integer) {
                return PermanentCommitsInfoImpl.this.getCommitId(integer);
            }
        });
    }

    @NotNull
    public Set<CommitId> convertToCommitIdSet(@NotNull Collection<Integer> commitIndexes) {
        return ContainerUtil.map2Set(commitIndexes, (Function)new Function<Integer, CommitId>(){

            public CommitId fun(Integer integer) {
                return PermanentCommitsInfoImpl.this.getCommitId(integer);
            }
        });
    }

    @Override
    @NotNull
    public Set<Integer> convertToNodeIds(@NotNull Collection<CommitId> commitIds) {
        return this.convertToNodeIds(commitIds, false);
    }

    @NotNull
    public Set<Integer> convertToNodeIds(@NotNull Collection<CommitId> commitIds, boolean reportNotFound) {
        Collection unmatchedIds;
        HashSet result2 = ContainerUtil.newHashSet();
        HashSet matchedIds = ContainerUtil.newHashSet();
        for (int i2 = 0; i2 < this.myCommitIdIndexes.size(); ++i2) {
            CommitId commitId = this.myCommitIdIndexes.get(i2);
            if (!commitIds.contains(commitId)) continue;
            result2.add(i2);
            matchedIds.add(commitId);
        }
        if (reportNotFound && !(unmatchedIds = ContainerUtil.subtract(commitIds, (Collection)matchedIds)).isEmpty()) {
            LOG.warn("Unmatched commit ids " + unmatchedIds);
        }
        for (Map.Entry<Integer, CommitId> entry : this.myNotLoadCommits.entrySet()) {
            if (!commitIds.contains(entry.getValue())) continue;
            result2.add(entry.getKey());
        }
        return result2;
    }
}

