/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print.elements;

import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import org.jetbrains.annotations.NotNull;

public class EdgePrintElementImpl
extends PrintElementWithGraphElement
implements EdgePrintElement {
    @NotNull
    private final EdgePrintElement.Type myType;
    @NotNull
    private final EdgePrintElement.LineStyle myLineStyle;
    private final int myPositionInOtherRow;
    private final boolean myHasArrow;

    @NotNull
    public static EdgePrintElement.LineStyle convertToLineStyle(@NotNull GraphEdgeType edgeType) {
        switch (edgeType) {
            case USUAL: 
            case NOT_LOAD_COMMIT: {
                return EdgePrintElement.LineStyle.SOLID;
            }
            case DOTTED: 
            case DOTTED_ARROW_UP: 
            case DOTTED_ARROW_DOWN: {
                return EdgePrintElement.LineStyle.DASHED;
            }
        }
        throw new IllegalStateException("Edge type not supported: " + (Object)((Object)edgeType));
    }

    public EdgePrintElementImpl(int rowIndex, int positionInCurrentRow, int positionInOtherRow, @NotNull EdgePrintElement.Type type2, @NotNull GraphEdge graphEdge, boolean hasArrow, @NotNull PrintElementManager printElementManager) {
        super(rowIndex, positionInCurrentRow, graphEdge, printElementManager);
        this.myType = type2;
        this.myLineStyle = EdgePrintElementImpl.convertToLineStyle(graphEdge.getType());
        this.myPositionInOtherRow = positionInOtherRow;
        this.myHasArrow = hasArrow;
    }

    public int getPositionInOtherRow() {
        return this.myPositionInOtherRow;
    }

    @NotNull
    public EdgePrintElement.Type getType() {
        return this.myType;
    }

    @NotNull
    public EdgePrintElement.LineStyle getLineStyle() {
        return this.myLineStyle;
    }

    public boolean hasArrow() {
        return this.myHasArrow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgePrintElement)) {
            return false;
        }
        EdgePrintElement that = (EdgePrintElement)o;
        if (this.myPositionInCurrentRow != that.getPositionInCurrentRow()) {
            return false;
        }
        if (this.myPositionInOtherRow != that.getPositionInOtherRow()) {
            return false;
        }
        if (this.myRowIndex != that.getRowIndex()) {
            return false;
        }
        if (this.myType != that.getType()) {
            return false;
        }
        return this.myHasArrow == that.hasArrow();
    }

    public int hashCode() {
        int result2 = this.myRowIndex;
        result2 = 31 * result2 + this.myPositionInCurrentRow;
        result2 = 31 * result2 + this.myPositionInOtherRow;
        result2 = 37 * result2 + this.myType.hashCode();
        result2 = 31 * result2 + (this.myHasArrow ? 1 : 0);
        return result2;
    }
}

