/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.IntStack;
import com.intellij.util.containers.Stack;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import org.jetbrains.annotations.NotNull;

public class DfsUtil {
    public static void walk(@NotNull LiteLinearGraph graph, int start, @NotNull NodeVisitor visitor) {
        BitSetFlags visited = new BitSetFlags(graph.nodesCount(), false);
        BitSetFlags visitedInSameDirection = new BitSetFlags(graph.nodesCount(), false);
        Stack stack = new Stack();
        stack.push((Object)new Pair((Object)start, (Object)true));
        block0: while (!stack.empty()) {
            int currentNode = (Integer)((Pair)stack.peek()).first;
            boolean down = (Boolean)((Pair)stack.peek()).second;
            if (!visited.get(currentNode)) {
                visited.set(currentNode, true);
                visitor.enterNode(currentNode);
            }
            for (int nextNode : graph.getNodes(currentNode, down ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP)) {
                if (visited.get(nextNode)) continue;
                stack.push((Object)new Pair((Object)nextNode, (Object)down));
                continue block0;
            }
            if (!visitedInSameDirection.get(currentNode)) {
                visitedInSameDirection.set(currentNode, true);
                visitor.exitNode(currentNode);
            }
            for (int nextNode : graph.getNodes(currentNode, down ? LiteLinearGraph.NodeFilter.UP : LiteLinearGraph.NodeFilter.DOWN)) {
                if (visited.get(nextNode)) continue;
                stack.push((Object)new Pair((Object)nextNode, (Object)(!down ? 1 : 0)));
                continue block0;
            }
            stack.pop();
        }
    }

    public static void walk(int startRowIndex, @NotNull NextNode nextNodeFun) {
        IntStack stack = new IntStack();
        stack.push(startRowIndex);
        while (!stack.empty()) {
            int nextNode = nextNodeFun.fun(stack.peek());
            if (nextNode == -10) {
                return;
            }
            if (nextNode != -1) {
                stack.push(nextNode);
                continue;
            }
            stack.pop();
        }
        stack.clear();
    }

    public static interface NodeVisitor {
        public void enterNode(int var1);

        public void exitNode(int var1);
    }

    public static interface NextNode {
        public static final int NODE_NOT_FOUND = -1;
        public static final int EXIT = -10;

        public int fun(int var1);
    }
}

