/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public class UnsignedBitSet
implements Cloneable {
    @NotNull
    private final BitSet myPositiveSet;
    @NotNull
    private final BitSet myNegativeSet;

    public UnsignedBitSet(@NotNull BitSet positiveSet, @NotNull BitSet negativeSet) {
        this.myPositiveSet = positiveSet;
        this.myNegativeSet = negativeSet;
    }

    public UnsignedBitSet() {
        this(new BitSet(), new BitSet());
    }

    private static int toPositive(int bitIndex) {
        return -bitIndex;
    }

    public void set(int bitIndex, boolean value2) {
        if (bitIndex >= 0) {
            this.myPositiveSet.set(bitIndex, value2);
        } else {
            this.myNegativeSet.set(UnsignedBitSet.toPositive(bitIndex), value2);
        }
    }

    public void set(int fromIndex, int toIndex, boolean value2) {
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        if (fromIndex >= 0) {
            this.myPositiveSet.set(fromIndex, toIndex + 1, value2);
        } else if (toIndex < 0) {
            this.myNegativeSet.set(UnsignedBitSet.toPositive(toIndex), UnsignedBitSet.toPositive(fromIndex) + 1, value2);
        } else {
            this.myPositiveSet.set(0, toIndex + 1, value2);
            this.myNegativeSet.set(UnsignedBitSet.toPositive(-1), UnsignedBitSet.toPositive(fromIndex) + 1, value2);
        }
    }

    public boolean get(int bitIndex) {
        if (bitIndex >= 0) {
            return this.myPositiveSet.get(bitIndex);
        }
        return this.myNegativeSet.get(UnsignedBitSet.toPositive(bitIndex));
    }

    public UnsignedBitSet clone() {
        return new UnsignedBitSet((BitSet)this.myPositiveSet.clone(), (BitSet)this.myNegativeSet.clone());
    }
}

