/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.FullIntList;
import com.intellij.vcs.log.graph.utils.impl.SmartDeltaCompressor;
import org.jetbrains.annotations.NotNull;

public class CompressedIntList
implements IntList {
    public static final int DEFAULT_BLOCK_SIZE = 30;
    private final int myBlockSize;
    @NotNull
    private final int[] myStrongValues;
    @NotNull
    private final IntList myCompressedDeltas;

    @NotNull
    public static IntList newInstance(int[] delegateArray) {
        return CompressedIntList.newInstance(delegateArray, 30);
    }

    @NotNull
    public static IntList newInstance(final int[] delegateArray, int blockSize) {
        return CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return delegateArray.length;
            }

            @Override
            public int get(int index) {
                return delegateArray[index];
            }
        }, blockSize);
    }

    @NotNull
    public static IntList newInstance(final IntList delegateList, final int blockSize) {
        if (blockSize < 1) {
            throw new IllegalArgumentException("Unsupported blockSize:" + blockSize);
        }
        if (delegateList.size() == 0) {
            return new FullIntList(new int[0]);
        }
        SmartDeltaCompressor intDeltaCompressor = SmartDeltaCompressor.newInstance(new IntList(){

            @Override
            public int size() {
                return delegateList.size();
            }

            @Override
            public int get(int index) {
                return delegateList.get(index) - delegateList.get(index - index % blockSize);
            }
        });
        int[] strongValues = new int[(delegateList.size() - 1) / blockSize + 1];
        for (int i2 = 0; i2 < strongValues.length; ++i2) {
            strongValues[i2] = delegateList.get(i2 * blockSize);
        }
        return new CompressedIntList(blockSize, strongValues, intDeltaCompressor);
    }

    private CompressedIntList(int blockSize, @NotNull int[] strongValues, @NotNull IntList compressedDeltas) {
        this.myBlockSize = blockSize;
        this.myStrongValues = strongValues;
        this.myCompressedDeltas = compressedDeltas;
    }

    @Override
    public int size() {
        return this.myCompressedDeltas.size();
    }

    @Override
    public int get(int index) {
        int strongIndex = index / this.myBlockSize;
        return this.myStrongValues[strongIndex] + this.myCompressedDeltas.get(index);
    }
}

