/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleRefGroup
implements RefGroup {
    @NotNull
    private final String myName;
    @NotNull
    private final List<VcsRef> myRefs;

    public SimpleRefGroup(@NotNull String name, @NotNull List<VcsRef> refs) {
        this.myName = name;
        this.myRefs = refs;
    }

    public boolean isExpanded() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<VcsRef> getRefs() {
        return this.myRefs;
    }

    @NotNull
    public List<Color> getColors() {
        return SimpleRefGroup.getColors(this.myRefs);
    }

    @NotNull
    public static List<Color> getColors(@NotNull Collection<VcsRef> refs) {
        MultiMap referencesByType = ContainerUtil.groupBy(refs, VcsRef::getType);
        if (referencesByType.size() == 1) {
            Map.Entry firstItem = (Map.Entry)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)referencesByType.entrySet()));
            boolean multiple = ((Collection)firstItem.getValue()).size() > 1;
            Color color = ((VcsRefType)firstItem.getKey()).getBackgroundColor();
            return multiple ? Arrays.asList(color, color) : Collections.singletonList(color);
        }
        ArrayList colorsList = ContainerUtil.newArrayList();
        for (VcsRefType type2 : referencesByType.keySet()) {
            if (referencesByType.get((Object)type2).size() > 1) {
                colorsList.add(type2.getBackgroundColor());
            }
            colorsList.add(type2.getBackgroundColor());
        }
        return colorsList;
    }

    public static void buildGroups(@NotNull MultiMap<VcsRefType, VcsRef> groupedRefs, boolean compact, boolean showTagNames, @NotNull List<RefGroup> result2) {
        if (groupedRefs.isEmpty()) {
            return;
        }
        if (compact) {
            VcsRef firstRef = (VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)groupedRefs.values()));
            RefGroup group = (RefGroup)ContainerUtil.getFirstItem(result2);
            if (group == null) {
                result2.add(new SimpleRefGroup(firstRef.getType().isBranch() || showTagNames ? firstRef.getName() : "", ContainerUtil.newArrayList((Iterable)groupedRefs.values())));
            } else {
                group.getRefs().addAll(groupedRefs.values());
            }
        } else {
            for (Map.Entry entry : groupedRefs.entrySet()) {
                if (((VcsRefType)entry.getKey()).isBranch()) {
                    for (VcsRef ref : (Collection)entry.getValue()) {
                        result2.add(new SimpleRefGroup(ref.getName(), ContainerUtil.newArrayList((Object[])new VcsRef[]{ref})));
                    }
                    continue;
                }
                result2.add(new SimpleRefGroup(showTagNames ? ((VcsRef)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())))).getName() : "", ContainerUtil.newArrayList((Iterable)((Iterable)entry.getValue()))));
            }
        }
    }
}

