/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.ContentsUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class VcsLogContentProvider
implements ChangesViewContentProvider {
    public static final String TAB_NAME = "Log";
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsProjectLog myProjectLog;
    @NotNull
    private final JPanel myContainer = new JBPanel((LayoutManager)new BorderLayout());

    public VcsLogContentProvider(@NotNull Project project2, @NotNull VcsProjectLog projectLog) {
        this.myProject = project2;
        this.myProjectLog = projectLog;
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
        connection.subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated() {
                VcsLogContentProvider.this.addLogUi();
            }

            @Override
            public void logDisposed() {
                VcsLogContentProvider.this.myContainer.removeAll();
                VcsLogContentProvider.this.closeLogTabs();
            }
        });
        if (this.myProjectLog.getLogManager() != null) {
            this.addLogUi();
        }
    }

    private void addLogUi() {
        this.myContainer.add((Component)this.myProjectLog.initMainLog(TAB_NAME), "Center");
    }

    @Override
    public JComponent initContent() {
        this.myProjectLog.createLog();
        return this.myContainer;
    }

    @Override
    public void disposeContent() {
        this.myContainer.removeAll();
        this.closeLogTabs();
    }

    public static <U extends AbstractVcsLogUi> boolean findAndSelectContent(@NotNull Project project2, @NotNull Class<U> clazz, @NotNull Condition<U> condition2) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        ContentManager manager = toolWindow.getContentManager();
        JComponent component = ContentUtilEx.findContentComponent(manager, (Condition<JComponent>)((Condition)c -> {
            if (c instanceof VcsLogPanel) {
                AbstractVcsLogUi ui = ((VcsLogPanel)((Object)((Object)c))).getUi();
                return clazz.isInstance(ui) && condition2.value((Object)ui);
            }
            return false;
        }));
        if (component == null) {
            return false;
        }
        if (!toolWindow.isVisible()) {
            toolWindow.activate(null);
        }
        return ContentUtilEx.selectContent(manager, component, true);
    }

    public static void openAnotherLogTab(@NotNull VcsLogManager logManager, @NotNull Project project2) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        String name = VcsLogContentProvider.generateShortName(toolWindow);
        VcsLogContentProvider.openLogTab(project2, logManager, TAB_NAME, name, logManager.getMainLogUiFactory(name));
    }

    public static <U extends AbstractVcsLogUi> void openLogTab(@NotNull Project project2, @NotNull VcsLogManager logManager, @NotNull String tabGroupName, @NotNull String shortName, @NotNull VcsLogManager.VcsLogUiFactory<U> factory) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        String name = ContentUtilEx.getFullName(tabGroupName, shortName);
        U logUi = logManager.createLogUi(name, factory);
        ContentUtilEx.addTabbedContent(toolWindow.getContentManager(), (JComponent)((Object)new VcsLogPanel(logManager, (AbstractVcsLogUi)logUi)), tabGroupName, shortName, true, logUi);
        toolWindow.activate(null);
        logManager.scheduleInitialization();
    }

    @NotNull
    private static String generateShortName(@NotNull ToolWindow toolWindow) {
        TabbedContent tabbedContent = ContentUtilEx.findTabbedContent(toolWindow.getContentManager(), TAB_NAME);
        if (tabbedContent != null) {
            return String.valueOf(tabbedContent.getTabs().size() + 1);
        }
        List contents = ContainerUtil.filter((Object[])toolWindow.getContentManager().getContents(), content -> TAB_NAME.equals(content.getUserData(Content.TAB_GROUP_NAME_KEY)));
        return String.valueOf(contents.size() + 1);
    }

    private void closeLogTabs() {
        VcsLogManager logManager;
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.VCS);
        if (toolWindow != null && (logManager = this.myProjectLog.getLogManager()) != null) {
            for (String tabName : logManager.getTabNames()) {
                if (TAB_NAME.equals(tabName)) continue;
                Content content = toolWindow.getContentManager().findContent(tabName);
                ContentsUtil.closeContentTab((ContentManager)toolWindow.getContentManager(), (Content)content);
            }
        }
    }

    public static class VcsLogVisibilityPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(Project project2) {
            return !VcsLogManager.findLogProviders(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project2).getAllVcsRoots()), project2).isEmpty();
        }
    }
}

