/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsWatcher;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @Nullable
    private final Consumer<Throwable> myRecreateMainLogHandler;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogColorManagerImpl myColorManager;
    @NotNull
    private final VcsLogTabsWatcher myTabsLogRefresher;
    @NotNull
    private final PostponableLogRefresher myPostponableRefresher;
    private boolean myInitialized = false;

    public VcsLogManager(@NotNull Project project2, @NotNull VcsLogTabsProperties uiProperties, @NotNull Collection<VcsRoot> roots) {
        this(project2, uiProperties, roots, true, null);
    }

    public VcsLogManager(@NotNull Project project2, @NotNull VcsLogTabsProperties uiProperties, @NotNull Collection<VcsRoot> roots, boolean scheduleRefreshImmediately, @Nullable Consumer<Throwable> recreateHandler) {
        this.myProject = project2;
        this.myUiProperties = uiProperties;
        this.myRecreateMainLogHandler = recreateHandler;
        Map<VirtualFile, VcsLogProvider> logProviders = VcsLogManager.findLogProviders(roots, this.myProject);
        this.myLogData = new VcsLogData(this.myProject, logProviders, new MyFatalErrorsHandler());
        this.myPostponableRefresher = new PostponableLogRefresher(this.myLogData);
        this.myTabsLogRefresher = new VcsLogTabsWatcher(this.myProject, this.myPostponableRefresher, this.myLogData);
        VcsLogManager.refreshLogOnVcsEvents(logProviders, this.myPostponableRefresher, this.myLogData);
        this.myColorManager = new VcsLogColorManagerImpl(logProviders.keySet());
        if (scheduleRefreshImmediately) {
            this.scheduleInitialization();
        }
        Disposer.register((Disposable)project2, (Disposable)this);
    }

    public void scheduleInitialization() {
        if (!this.myInitialized) {
            this.myInitialized = true;
            this.myLogData.initialize();
        }
    }

    public boolean isLogVisible() {
        return this.myPostponableRefresher.isLogVisible();
    }

    @NotNull
    public VcsLogData getDataManager() {
        return this.myLogData;
    }

    @NotNull
    public JComponent createLogPanel(@NotNull String logId, @Nullable String contentTabName) {
        VcsLogUiImpl ui = this.createLogUi(logId, contentTabName);
        return new VcsLogPanel(this, ui);
    }

    @NotNull
    public VcsLogUiImpl createLogUi(@NotNull String logId, @Nullable String contentTabName) {
        return this.createLogUi(contentTabName, this.getMainLogUiFactory(logId));
    }

    @NotNull
    public VcsLogUiFactory<? extends VcsLogUiImpl> getMainLogUiFactory(@NotNull String logId) {
        return new MainVcsLogUiFactory(logId);
    }

    @NotNull
    public <U extends AbstractVcsLogUi> U createLogUi(@Nullable String contentTabName, @NotNull VcsLogUiFactory<U> factory) {
        U ui = factory.createLogUi(this.myProject, this.myLogData, this.myColorManager);
        Disposable disposable = contentTabName != null ? this.myTabsLogRefresher.addTabToWatch(contentTabName, ((AbstractVcsLogUi)ui).getRefresher()) : this.myPostponableRefresher.addLogWindow(((AbstractVcsLogUi)ui).getRefresher());
        Disposer.register(ui, (Disposable)disposable);
        ((AbstractVcsLogUi)ui).requestFocus();
        return ui;
    }

    private static void refreshLogOnVcsEvents(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogRefresher refresher, @NotNull Disposable disposableParent) {
        MultiMap providers2roots = MultiMap.create();
        logProviders.forEach((key2, value2) -> providers2roots.putValue(value2, key2));
        for (Map.Entry entry : providers2roots.entrySet()) {
            Disposable disposable = ((VcsLogProvider)entry.getKey()).subscribeToRootRefreshEvents((Collection)entry.getValue(), refresher);
            Disposer.register((Disposable)disposableParent, (Disposable)disposable);
        }
    }

    @NotNull
    public static Map<VirtualFile, VcsLogProvider> findLogProviders(@NotNull Collection<VcsRoot> roots, @NotNull Project project2) {
        HashMap logProviders = ContainerUtil.newHashMap();
        VcsLogProvider[] allLogProviders = (VcsLogProvider[])Extensions.getExtensions((ExtensionPointName)VcsLogProvider.LOG_PROVIDER_EP, (AreaInstance)project2);
        block0: for (VcsRoot root : roots) {
            AbstractVcs vcs = root.getVcs();
            VirtualFile path = root.getPath();
            if (vcs == null || path == null) {
                LOG.error("Skipping invalid VCS root: " + root);
                continue;
            }
            for (VcsLogProvider provider2 : allLogProviders) {
                if (!provider2.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
                logProviders.put(path, provider2);
                continue block0;
            }
        }
        return logProviders;
    }

    public void disposeLog() {
        Disposer.dispose((Disposable)this.myLogData);
    }

    @Deprecated
    @Nullable
    public static VcsLogManager getInstance(@NotNull Project project2) {
        return ((VcsProjectLog)ServiceManager.getService((Project)project2, VcsProjectLog.class)).getLogManager();
    }

    @Deprecated
    @Nullable
    public VcsLogUiImpl getMainLogUi() {
        return ((VcsProjectLog)ServiceManager.getService((Project)this.myProject, VcsProjectLog.class)).getMainLogUi();
    }

    public void dispose() {
        this.disposeLog();
    }

    @NotNull
    public Set<String> getTabNames() {
        return this.myTabsLogRefresher.getTabNames();
    }

    private class MainVcsLogUiFactory
    implements VcsLogUiFactory<VcsLogUiImpl> {
        private final String myLogId;

        public MainVcsLogUiFactory(String logId) {
            this.myLogId = logId;
        }

        @Override
        public VcsLogUiImpl createLogUi(@NotNull Project project2, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager) {
            MainVcsLogUiProperties properties = VcsLogManager.this.myUiProperties.createProperties(this.myLogId);
            VisiblePackRefresherImpl refresher = new VisiblePackRefresherImpl(project2, logData, properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE), new VcsLogFilterer(logData.getLogProviders(), logData.getStorage(), logData.getTopCommitsCache(), logData.getCommitDetailsGetter(), logData.getIndex()));
            return new VcsLogUiImpl(logData, project2, manager, properties, refresher);
        }
    }

    @FunctionalInterface
    public static interface VcsLogUiFactory<T extends AbstractVcsLogUi> {
        public T createLogUi(@NotNull Project var1, @NotNull VcsLogData var2, @NotNull VcsLogColorManager var3);
    }

    private class MyFatalErrorsHandler
    implements FatalErrorHandler {
        private final AtomicBoolean myIsBroken = new AtomicBoolean(false);

        private MyFatalErrorsHandler() {
        }

        @Override
        public void consume(@Nullable Object source, @NotNull Exception e) {
            if (this.myIsBroken.compareAndSet(false, true)) {
                this.processError(source, e);
            } else {
                LOG.debug("Vcs Log storage is broken and is being recreated", (Throwable)e);
            }
        }

        protected void processError(@Nullable Object source, @NotNull Exception e) {
            if (VcsLogManager.this.myRecreateMainLogHandler != null) {
                ApplicationManager.getApplication().invokeLater(() -> VcsLogManager.this.myRecreateMainLogHandler.consume((Object)e));
            } else {
                LOG.error((Throwable)e);
            }
            if (source instanceof VcsLogStorage) {
                VcsLogManager.this.myLogData.getIndex().markCorrupted();
            }
        }

        @Override
        public void displayFatalErrorMessage(@NotNull String message2) {
            VcsBalloonProblemNotifier.showOverChangesView(VcsLogManager.this.myProject, message2, MessageType.ERROR, new NamedRunnable[0]);
        }
    }
}

