/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.TimedVcsCommitImpl;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.vcs.log.impl.VcsRefImpl;
import com.intellij.vcs.log.impl.VcsShortCommitDetailsImpl;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsLogObjectsFactoryImpl
implements VcsLogObjectsFactory {
    @NotNull
    private final VcsUserRegistry myUserRegistry;

    private VcsLogObjectsFactoryImpl(@NotNull VcsUserRegistry userRegistry) {
        this.myUserRegistry = userRegistry;
    }

    @NotNull
    public Hash createHash(@NotNull String stringHash) {
        return HashImpl.build(stringHash);
    }

    @NotNull
    public TimedVcsCommit createTimedCommit(@NotNull Hash hash, @NotNull List<Hash> parents, long timeStamp) {
        return new TimedVcsCommitImpl(hash, parents, timeStamp);
    }

    @NotNull
    public VcsShortCommitDetails createShortDetails(@NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull String authorName, String authorEmail, @NotNull String committerName, @NotNull String committerEmail, long authorTime) {
        VcsUser author = this.createUser(authorName, authorEmail);
        VcsUser committer = this.createUser(committerName, committerEmail);
        return new VcsShortCommitDetailsImpl(hash, parents, commitTime, root, subject, author, committer, authorTime);
    }

    @NotNull
    public VcsCommitMetadata createCommitMetadata(@NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull String authorName, @NotNull String authorEmail, @NotNull String message2, @NotNull String committerName, @NotNull String committerEmail, long authorTime) {
        VcsUser author = this.createUser(authorName, authorEmail);
        VcsUser committer = this.createUser(committerName, committerEmail);
        return new VcsCommitMetadataImpl(hash, parents, commitTime, root, subject, author, message2, committer, authorTime);
    }

    @NotNull
    public VcsFullCommitDetails createFullDetails(@NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, VirtualFile root, @NotNull String subject, @NotNull String authorName, @NotNull String authorEmail, @NotNull String message2, @NotNull String committerName, @NotNull String committerEmail, long authorTime, @NotNull ThrowableComputable<Collection<Change>, ? extends Exception> changesGetter) {
        VcsUser author = this.createUser(authorName, authorEmail);
        VcsUser committer = this.createUser(committerName, committerEmail);
        return new VcsChangesLazilyParsedDetails(hash, parents, commitTime, root, subject, author, message2, committer, authorTime, changesGetter);
    }

    @NotNull
    public VcsUser createUser(@NotNull String name, @NotNull String email) {
        return this.myUserRegistry.createUser(name, email);
    }

    @NotNull
    public VcsRef createRef(@NotNull Hash commitHash, @NotNull String name, @NotNull VcsRefType type2, @NotNull VirtualFile root) {
        return new VcsRefImpl(commitHash, name, type2, root);
    }
}

