/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsProjectLog {
    private static final Logger LOG = Logger.getInstance(VcsProjectLog.class);
    public static final Topic<ProjectLogListener> VCS_PROJECT_LOG_CHANGED = Topic.create((String)"Project Vcs Log Created or Disposed", ProjectLogListener.class);
    private static final int RECREATE_LOG_TRIES = 5;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @NotNull
    private final LazyVcsLogManager myLogManager = new LazyVcsLogManager();
    private int myRecreatedLogCount = 0;
    private volatile VcsLogUiImpl myUi;

    public VcsProjectLog(@NotNull Project project2, @NotNull VcsLogTabsProperties uiProperties) {
        this.myProject = project2;
        this.myMessageBus = project2.getMessageBus();
        this.myUiProperties = uiProperties;
    }

    @Nullable
    public VcsLogData getDataManager() {
        VcsLogManager cached = this.myLogManager.getCached();
        if (cached == null) {
            return null;
        }
        return cached.getDataManager();
    }

    @NotNull
    private Collection<VcsRoot> getVcsRoots() {
        return Arrays.asList(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcsRoots());
    }

    @NotNull
    public JComponent initMainLog(@NotNull String contentTabName) {
        this.myUi = this.myLogManager.getValue().createLogUi("MAIN", contentTabName);
        return new VcsLogPanel(this.myLogManager.getValue(), this.myUi);
    }

    @Nullable
    public VcsLogUiImpl getMainLogUi() {
        return this.myUi;
    }

    @Nullable
    public VcsLogManager getLogManager() {
        return this.myLogManager.getCached();
    }

    private void recreateLog() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.disposeLog();
            if (this.hasDvcsRoots()) {
                this.createLog();
            }
        });
    }

    private void recreateOnError(@NotNull Throwable t) {
        if (++this.myRecreatedLogCount > 5) {
            String message2 = String.format("VCS Log was recreated %d times due to data corruption\nDelete %s directory and restart %s if this happens often.\n%s", this.myRecreatedLogCount, PersistentUtil.LOG_CACHE, ApplicationNamesInfo.getInstance().getFullProductName(), t.getMessage());
            this.myRecreatedLogCount = 0;
            LOG.error(message2, t);
            VcsLogManager manager = this.getLogManager();
            if (manager != null && manager.isLogVisible()) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message2, MessageType.ERROR, new NamedRunnable[0]);
            }
        } else {
            LOG.debug("Recreating VCS Log after storage corruption", t);
        }
        this.recreateLog();
    }

    private void disposeLog() {
        this.myUi = null;
        this.myLogManager.drop();
    }

    public void createLog() {
        VcsLogCachesInvalidator invalidator;
        VcsLogManager logManager = this.myLogManager.getValue();
        if (logManager.isLogVisible()) {
            logManager.scheduleInitialization();
        } else if (PostponableLogRefresher.keepUpToDate() && (invalidator = (VcsLogCachesInvalidator)((Object)CachesInvalidator.EP_NAME.findExtension(VcsLogCachesInvalidator.class))).isValid()) {
            HeavyAwareExecutor.executeOutOfHeavyProcessLater(logManager::scheduleInitialization, 5000);
        }
    }

    private boolean hasDvcsRoots() {
        return !VcsLogManager.findLogProviders(this.getVcsRoots(), this.myProject).isEmpty();
    }

    public static VcsProjectLog getInstance(@NotNull Project project2) {
        return (VcsProjectLog)ServiceManager.getService((Project)project2, VcsProjectLog.class);
    }

    public static interface ProjectLogListener {
        public void logCreated();

        public void logDisposed();
    }

    public static class InitLogStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project2) {
            if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return;
            }
            VcsProjectLog projectLog = VcsProjectLog.getInstance(project2);
            MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
            connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> projectLog.recreateLog());
            if (projectLog.hasDvcsRoots()) {
                ApplicationManager.getApplication().invokeLater(projectLog::createLog);
            }
        }
    }

    private class LazyVcsLogManager {
        @Nullable
        private VcsLogManager myValue;

        private LazyVcsLogManager() {
        }

        @NotNull
        public synchronized VcsLogManager getValue() {
            if (this.myValue == null) {
                this.myValue = this.compute();
                ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logCreated();
            }
            return this.myValue;
        }

        @NotNull
        protected synchronized VcsLogManager compute() {
            return new VcsLogManager(VcsProjectLog.this.myProject, VcsProjectLog.this.myUiProperties, VcsProjectLog.this.getVcsRoots(), false, (Consumer<Throwable>)((Consumer)x$0 -> VcsProjectLog.this.recreateOnError(x$0)));
        }

        public synchronized void drop() {
            if (this.myValue != null) {
                ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logDisposed();
                Disposer.dispose((Disposable)this.myValue);
            }
            this.myValue = null;
        }

        @Nullable
        public synchronized VcsLogManager getCached() {
            return this.myValue;
        }
    }
}

