/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogImpl;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVcsLogUi
implements VcsLogUi,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogUiImpl.class);
    public static final ExtensionPointName<VcsLogHighlighterFactory> LOG_HIGHLIGHTER_FACTORY_EP = ExtensionPointName.create((String)"com.intellij.logHighlighterFactory");
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VcsLogData myLogData;
    @NotNull
    protected final VcsLogColorManager myColorManager;
    @NotNull
    protected final VcsLog myLog;
    @NotNull
    protected final VisiblePackRefresher myRefresher;
    @NotNull
    protected final Collection<VcsLogListener> myLogListeners = ContainerUtil.newArrayList();
    @NotNull
    protected final VisiblePackChangeListener myVisiblePackChangeListener;
    @NotNull
    protected VisiblePack myVisiblePack;

    public AbstractVcsLogUi(@NotNull VcsLogData logData, @NotNull Project project2, @NotNull VcsLogColorManager manager, @NotNull VisiblePackRefresher refresher) {
        this.myProject = project2;
        this.myLogData = logData;
        this.myRefresher = refresher;
        this.myColorManager = manager;
        Disposer.register((Disposable)this, (Disposable)this.myRefresher);
        Disposer.register((Disposable)logData, (Disposable)this);
        this.myLog = new VcsLogImpl(logData, this);
        this.myVisiblePack = VisiblePack.EMPTY;
        this.myVisiblePackChangeListener = visiblePack -> UIUtil.invokeLaterIfNeeded(() -> {
            if (!Disposer.isDisposed((Disposable)this)) {
                this.setVisiblePack(visiblePack);
            }
        });
        this.myRefresher.addVisiblePackChangeListener(this.myVisiblePackChangeListener);
    }

    public void requestFocus() {
        VcsLogGraphTable graphTable = this.getTable();
        if (graphTable.getRowCount() > 0) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)graphTable), true).doWhenProcessed(() -> graphTable.setRowSelectionInterval(0, 0));
        }
    }

    public void setVisiblePack(@NotNull VisiblePack pack) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean permGraphChanged = this.myVisiblePack.getDataPack() != pack.getDataPack();
        this.myVisiblePack = pack;
        this.onVisiblePackUpdated(permGraphChanged);
        this.fireFilterChangeEvent(this.myVisiblePack, permGraphChanged);
        this.getTable().repaint();
    }

    protected abstract void onVisiblePackUpdated(boolean var1);

    @NotNull
    public abstract VcsLogGraphTable getTable();

    @NotNull
    public abstract Component getMainComponent();

    protected abstract VcsLogFilterCollection getFilters();

    @NotNull
    public abstract VcsLogUiProperties getProperties();

    public abstract boolean isShowRootNames();

    public boolean areGraphActionsEnabled() {
        return this.getTable().getRowCount() > 0;
    }

    @NotNull
    public VisiblePackRefresher getRefresher() {
        return this.myRefresher;
    }

    @NotNull
    public VcsLogColorManager getColorManager() {
        return this.myColorManager;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public VcsLog getVcsLog() {
        return this.myLog;
    }

    @NotNull
    public VcsLogData getLogData() {
        return this.myLogData;
    }

    @NotNull
    public VisiblePack getDataPack() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myVisiblePack;
    }

    @NotNull
    public Future<Boolean> jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        SettableFuture future2 = SettableFuture.create();
        this.jumpToCommit(commitHash, root, (SettableFuture<Boolean>)future2);
        return future2;
    }

    public void jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root, @NotNull SettableFuture<Boolean> future2) {
        this.jumpTo(commitHash, (model, hash) -> model.getRowOfCommit((Hash)hash, root), future2);
    }

    public void jumpToCommitByPartOfHash(@NotNull String commitHash, @NotNull SettableFuture<Boolean> future2) {
        this.jumpTo(commitHash, GraphTableModel::getRowOfCommitByPartOfHash, future2);
    }

    private <T> void jumpTo(@NotNull T commitId, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter, @NotNull SettableFuture<Boolean> future2) {
        if (future2.isCancelled()) {
            return;
        }
        GraphTableModel model = this.getTable().getModel();
        int row = (Integer)rowGetter.fun((Object)model, commitId);
        if (row >= 0) {
            this.getTable().jumpToRow(row);
            future2.set((Object)true);
        } else if (model.canRequestMore()) {
            model.requestToLoadMore(() -> this.jumpTo(commitId, rowGetter, future2));
        } else if (!this.myVisiblePack.isFull()) {
            this.invokeOnChange(() -> this.jumpTo(commitId, rowGetter, future2));
        } else {
            this.commitNotFound(commitId.toString());
            future2.set((Object)false);
        }
    }

    private void showMessage(@NotNull MessageType messageType, @NotNull String message2) {
        LOG.info(message2);
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message2, messageType, new NamedRunnable[0]);
    }

    private void commitNotFound(@NotNull String commitHash) {
        if (this.getFilters().isEmpty()) {
            this.showMessage(MessageType.WARNING, "Commit " + commitHash + " not found");
        } else {
            this.showMessage(MessageType.WARNING, "Commit " + commitHash + " doesn't exist or doesn't match the active filters");
        }
    }

    public void addLogListener(@NotNull VcsLogListener listener2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.add(listener2);
    }

    public void removeLogListener(@NotNull VcsLogListener listener2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.remove(listener2);
    }

    protected void fireFilterChangeEvent(@NotNull VisiblePack visiblePack, boolean refresh) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<VcsLogListener> logListeners = new ArrayList<VcsLogListener>(this.myLogListeners);
        for (VcsLogListener listener2 : logListeners) {
            listener2.onChange((VcsLogDataPack)visiblePack, refresh);
        }
    }

    public void invokeOnChange(final @NotNull Runnable runnable2) {
        this.addLogListener(new VcsLogListener(){

            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
                runnable2.run();
                AbstractVcsLogUi.this.removeLogListener(this);
            }
        });
    }

    public void dispose() {
        this.myRefresher.removeVisiblePackChangeListener(this.myVisiblePackChangeListener);
        this.getTable().removeAllHighlighters();
        this.myVisiblePack = VisiblePack.EMPTY;
    }
}

