/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsLogColorManagerImpl
implements VcsLogColorManager {
    private static final Logger LOG = Logger.getInstance(VcsLogColorManagerImpl.class);
    private static Color[] ROOT_COLORS = new Color[]{JBColor.RED, JBColor.GREEN, JBColor.BLUE, JBColor.ORANGE, JBColor.CYAN, JBColor.YELLOW, JBColor.MAGENTA, JBColor.PINK};
    @NotNull
    private final List<VirtualFile> myRoots;
    @NotNull
    private final Map<VirtualFile, Color> myRoots2Colors;

    public VcsLogColorManagerImpl(@NotNull Collection<VirtualFile> roots) {
        this.myRoots = new ArrayList<VirtualFile>(roots);
        Collections.sort(this.myRoots, Comparator.comparing(VirtualFile::getName));
        this.myRoots2Colors = ContainerUtil.newHashMap();
        int i2 = 0;
        for (VirtualFile root : this.myRoots) {
            Color color;
            if (i2 >= ROOT_COLORS.length) {
                double balance = (double)(i2 / ROOT_COLORS.length) / (double)(roots.size() / ROOT_COLORS.length);
                Color mix = ColorUtil.mix((Color)ROOT_COLORS[i2 % ROOT_COLORS.length], (Color)ROOT_COLORS[(i2 + 1) % ROOT_COLORS.length], (double)balance);
                int tones = (int)(Math.abs(balance - 0.5) * 2.0 * (double)(roots.size() / ROOT_COLORS.length) + 1.0);
                color = new JBColor(ColorUtil.darker((Color)mix, (int)tones), ColorUtil.brighter((Color)mix, (int)(2 * tones)));
            } else {
                color = ROOT_COLORS[i2];
            }
            ++i2;
            this.myRoots2Colors.put(root, color);
        }
    }

    @NotNull
    public static JBColor getBackgroundColor(@NotNull Color baseRootColor) {
        return new JBColor(() -> ColorUtil.mix((Color)baseRootColor, (Color)UIUtil.getTableBackground(), (double)0.75));
    }

    @Override
    public boolean isMultipleRoots() {
        return this.myRoots.size() > 1;
    }

    @Override
    @NotNull
    public Color getRootColor(@NotNull VirtualFile root) {
        Color color = this.myRoots2Colors.get(root);
        if (color == null) {
            LOG.error("No color record for root " + root + ". All roots: " + this.myRoots2Colors);
            color = VcsLogColorManagerImpl.getDefaultRootColor();
        }
        return color;
    }

    private static Color getDefaultRootColor() {
        return UIUtil.getTableBackground();
    }
}

