/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesImpl;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.MainFrame;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class VcsLogUiImpl
extends AbstractVcsLogUi {
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final MainFrame myMainFrame;
    @NotNull
    private final VcsLogUiPropertiesImpl.MainVcsLogUiPropertiesListener myPropertiesListener;

    public VcsLogUiImpl(@NotNull VcsLogData logData, @NotNull Project project2, @NotNull VcsLogColorManager manager, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePackRefresher refresher) {
        super(logData, project2, manager, refresher);
        this.myUiProperties = uiProperties;
        this.myMainFrame = new MainFrame(logData, this, project2, uiProperties, this.myLog, this.myVisiblePack);
        for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])Extensions.getExtensions((ExtensionPointName)LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)this.myProject)) {
            this.getTable().addHighlighter(factory.createHighlighter(logData, this));
        }
        this.myPropertiesListener = new MyVcsLogUiPropertiesListener();
        this.myUiProperties.addChangeListener(this.myPropertiesListener);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myMainFrame.updateDataPack(this.myVisiblePack, permGraphChanged);
        this.myPropertiesListener.onShowLongEdgesChanged();
    }

    @NotNull
    public MainFrame getMainFrame() {
        return this.myMainFrame;
    }

    private void performLongAction(@NotNull GraphAction graphAction, @NotNull String title) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GraphAnswer answer = this.myVisiblePack.getVisibleGraph().getActionController().performAction(graphAction);
            Runnable updater = answer.getGraphUpdater();
            ApplicationManager.getApplication().invokeLater(() -> {
                assert (updater != null) : "Action:" + title + "\nController: " + this.myVisiblePack.getVisibleGraph().getActionController() + "\nAnswer:" + answer;
                updater.run();
                this.getTable().handleAnswer((GraphAnswer<Integer>)answer, true);
            });
        }, title, false, null, this.getMainFrame().getMainComponent());
    }

    public void expandAll() {
        this.performLongAction((GraphAction)new GraphAction.GraphActionImpl(null, GraphAction.Type.BUTTON_EXPAND), "Expanding " + (this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.LinearBek ? "merges..." : "linear branches..."));
    }

    public void collapseAll() {
        this.performLongAction((GraphAction)new GraphAction.GraphActionImpl(null, GraphAction.Type.BUTTON_COLLAPSE), "Collapsing " + (this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.LinearBek ? "merges..." : "linear branches..."));
    }

    @Override
    public boolean isShowRootNames() {
        return this.myUiProperties.get(MainVcsLogUiProperties.SHOW_ROOT_NAMES);
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        MainVcsLogUiProperties.VcsLogHighlighterProperty property = MainVcsLogUiProperties.VcsLogHighlighterProperty.get(id);
        return this.myUiProperties.exists(property) && this.myUiProperties.get(property) != false;
    }

    public boolean isMultipleRoots() {
        return this.myColorManager.isMultipleRoots();
    }

    public void applyFiltersAndUpdateUi(@NotNull VcsLogFilterCollection filters) {
        this.myRefresher.onFiltersChange(filters);
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        return this.myMainFrame.getGraphTable();
    }

    @Override
    @NotNull
    protected VcsLogFilterCollection getFilters() {
        return this.myMainFrame.getFilterUi().getFilters();
    }

    @Override
    @NotNull
    public Component getMainComponent() {
        return this.myMainFrame.getMainComponent();
    }

    @NotNull
    public JComponent getToolbar() {
        return this.myMainFrame.getToolbar();
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        return this.myMainFrame.getFilterUi();
    }

    @Override
    @NotNull
    public MainVcsLogUiProperties getProperties() {
        return this.myUiProperties;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesListener);
        super.dispose();
    }

    private class MyVcsLogUiPropertiesListener
    extends VcsLogUiPropertiesImpl.MainVcsLogUiPropertiesListener {
        private MyVcsLogUiPropertiesListener() {
        }

        @Override
        public void onShowDetailsChanged() {
            VcsLogUiImpl.this.myMainFrame.showDetails(VcsLogUiImpl.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
        }

        @Override
        public void onShowLongEdgesChanged() {
            VcsLogUiImpl.this.myVisiblePack.getVisibleGraph().getActionController().setLongEdgesHidden(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_LONG_EDGES) == false);
        }

        @Override
        public void onBekChanged() {
            VcsLogUiImpl.this.myRefresher.onSortTypeChange(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE));
        }

        @Override
        public void onShowRootNamesChanged() {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().rootColumnUpdated();
        }

        @Override
        public void onHighlighterChanged() {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().repaint();
        }

        @Override
        public void onCompactReferencesViewChanged() {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().setCompactReferencesView(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
        }

        @Override
        public void onShowTagNamesChanged() {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().setShowTagNames(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
        }

        @Override
        public void onColumnWidthChanged(int column) {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().forceReLayout(column);
        }

        @Override
        public void onColumnOrderChanged() {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().onColumnOrderSettingChanged();
        }

        @Override
        public void onTextFilterSettingsChanged() {
            VcsLogUiImpl.this.applyFiltersAndUpdateUi(VcsLogUiImpl.this.myMainFrame.getFilterUi().getFilters());
        }
    }
}

