/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.ContentsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloseLogTabAction
extends CloseTabToolbarAction {
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        if (e.getProject() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ContentManager contentManager = CloseLogTabAction.getContentManager(e.getProject());
        if (contentManager == null || CloseLogTabAction.getTabbedContent(contentManager) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        assert (project2 != null);
        ContentManager contentManager = CloseLogTabAction.getContentManager(project2);
        if (contentManager == null) {
            return;
        }
        Content selectedContent = CloseLogTabAction.getTabbedContent(contentManager);
        if (selectedContent != null) {
            ContentsUtil.closeContentTab((ContentManager)contentManager, (Content)selectedContent);
        }
    }

    @Nullable
    private static Content getTabbedContent(@NotNull ContentManager contentManager) {
        Content content = contentManager.getSelectedContent();
        if (content != null && (ContentUtilEx.isContentTab(content, "Log") || ContentUtilEx.isContentTab(content, "History"))) {
            return content;
        }
        return null;
    }

    @Nullable
    private static ContentManager getContentManager(@NotNull Project project2) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        if (toolWindow == null) {
            return null;
        }
        return toolWindow.getContentManager();
    }
}

