/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public abstract class TextFieldWithProgress
extends JPanel {
    @NotNull
    private final TextFieldWithCompletion myTextField;
    @NotNull
    private final AsyncProcessIcon myProgressIcon;

    public TextFieldWithProgress(@NotNull Project project2, @NotNull TextCompletionProvider completionProvider) {
        super(new BorderLayout());
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)3));
        this.myProgressIcon = new AsyncProcessIcon("Loading commits");
        this.myTextField = new TextFieldWithCompletion(project2, completionProvider, "", true, true, false){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(bg);
                TextFieldWithProgress.this.myProgressIcon.setBackground(bg);
            }

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition2, boolean pressed) {
                if (e.getKeyCode() == 10) {
                    TextFieldWithProgress.this.onOk();
                    return true;
                }
                return false;
            }
        };
        this.myTextField.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myProgressIcon.setOpaque(true);
        this.myProgressIcon.setBackground(this.myTextField.getBackground());
        this.add((Component)((Object)this.myTextField), "Center");
        this.add((Component)this.myProgressIcon, "East");
        this.hideProgress();
    }

    public JComponent getPreferableFocusComponent() {
        return this.myTextField;
    }

    public void showProgress() {
        this.myTextField.setEnabled(false);
        this.myProgressIcon.setVisible(true);
    }

    public void hideProgress() {
        this.myTextField.setEnabled(true);
        this.myProgressIcon.setVisible(false);
    }

    public String getText() {
        return this.myTextField.getText();
    }

    public abstract void onOk();
}

