/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.StandardDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.ui.actions.history.FileHistorySingleCommitAction;
import com.intellij.vcs.log.ui.history.FileHistoryUi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffWithLocalFromHistoryAction
extends FileHistorySingleCommitAction {
    @Override
    protected boolean isEnabled(@NotNull FileHistoryUi ui, @Nullable VcsFullCommitDetails detail, @NotNull AnActionEvent e) {
        VcsFileRevision fileRevision;
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        if (filePath == null || filePath.isDirectory() || filePath.getVirtualFile() == null) {
            return false;
        }
        return detail == null || (fileRevision = ui.createRevision(detail)) != null;
    }

    @Override
    protected void performAction(@NotNull Project project2, @NotNull FileHistoryUi ui, @NotNull VcsFullCommitDetails detail, @NotNull AnActionEvent e) {
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(null)) {
            return;
        }
        FilePath path = (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH);
        VcsFileRevision revision = ui.createRevision(detail);
        if (revision != null) {
            StandardDiffFromHistoryHandler handler2 = new StandardDiffFromHistoryHandler();
            handler2.showDiffForTwo(project2, path, revision, (VcsFileRevision)new CurrentRevision((VirtualFile)ObjectUtils.notNull((Object)path.getVirtualFile()), VcsRevisionNumber.NULL));
        }
    }
}

