/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.vcs.versionBrowser.DateFilterComponent;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.data.VcsLogDateFilterImpl;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DateFilterPopupComponent
extends FilterPopupComponent<VcsLogDateFilter> {
    public DateFilterPopupComponent(FilterModel<VcsLogDateFilter> filterModel) {
        super("Date", filterModel);
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogDateFilter filter) {
        Date after2 = filter.getAfter();
        Date before = filter.getBefore();
        if (after2 != null && before != null) {
            return DateFormatUtil.formatDate((Date)after2) + "-" + DateFormatUtil.formatDate((Date)before);
        }
        if (after2 != null) {
            return "Since " + DateFormatUtil.formatDate((Date)after2);
        }
        if (before != null) {
            return "Until " + DateFormatUtil.formatDate((Date)before);
        }
        return "All";
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogDateFilter filter) {
        return null;
    }

    @Override
    protected ActionGroup createActionGroup() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(6, -1);
        Date oneDayBefore = cal.getTime();
        cal.add(6, -6);
        Date oneWeekBefore = cal.getTime();
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectAction(), new DateAction(oneDayBefore, "Last 24 hours"), new DateAction(oneWeekBefore, "Last 7 days")});
    }

    private class SelectAction
    extends DumbAwareAction {
        SelectAction() {
            super("Select...");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DateFilterComponent dateComponent = new DateFilterComponent(false, DateFormatUtil.getDateFormat().getDelegate());
            VcsLogDateFilter currentFilter = (VcsLogDateFilter)DateFilterPopupComponent.this.myFilterModel.getFilter();
            if (currentFilter != null) {
                if (currentFilter.getBefore() != null) {
                    dateComponent.setBefore(currentFilter.getBefore().getTime());
                }
                if (currentFilter.getAfter() != null) {
                    dateComponent.setAfter(currentFilter.getAfter().getTime());
                }
            }
            DialogBuilder db = new DialogBuilder((Component)DateFilterPopupComponent.this);
            db.addOkAction();
            db.setCenterPanel((JComponent)dateComponent.getPanel());
            db.setPreferredFocusComponent((JComponent)dateComponent.getPanel());
            db.setTitle("Select Period");
            if (0 == db.show()) {
                long after2 = dateComponent.getAfter();
                long before = dateComponent.getBefore();
                VcsLogDateFilterImpl filter = new VcsLogDateFilterImpl(after2 > 0L ? new Date(after2) : null, before > 0L ? new Date(before) : null);
                DateFilterPopupComponent.this.myFilterModel.setFilter(filter);
            }
        }
    }

    private class DateAction
    extends DumbAwareAction {
        @NotNull
        private final Date mySince;

        DateAction(@NotNull Date since, String text) {
            super(text);
            this.mySince = since;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DateFilterPopupComponent.this.myFilterModel.setFilter(new VcsLogDateFilterImpl(this.mySince, null));
        }
    }
}

