/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FilterModel<Filter extends VcsLogFilter> {
    @NotNull
    private final String myName;
    @NotNull
    protected final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final Computable<VcsLogDataPack> myDataPackProvider;
    @NotNull
    private final Collection<Runnable> mySetFilterListeners = ContainerUtil.newArrayList();
    @Nullable
    private Filter myFilter;

    FilterModel(@NotNull String name, @NotNull Computable<VcsLogDataPack> provider2, @NotNull MainVcsLogUiProperties uiProperties) {
        this.myName = name;
        this.myUiProperties = uiProperties;
        this.myDataPackProvider = provider2;
    }

    void setFilter(@Nullable Filter filter) {
        this.myFilter = filter;
        this.saveFilter(filter);
        for (Runnable listener2 : this.mySetFilterListeners) {
            listener2.run();
        }
    }

    protected void saveFilter(@Nullable Filter filter) {
        this.myUiProperties.saveFilterValues(this.myName, filter == null ? null : this.getFilterValues(filter));
    }

    @Nullable
    Filter getFilter() {
        if (this.myFilter == null) {
            this.myFilter = this.getLastFilter();
        }
        return this.myFilter;
    }

    @Nullable
    protected abstract Filter createFilter(@NotNull List<String> var1);

    @NotNull
    protected abstract List<String> getFilterValues(@NotNull Filter var1);

    @Nullable
    protected Filter getLastFilter() {
        List<String> values = this.myUiProperties.getFilterValues(this.myName);
        if (values != null) {
            return this.createFilter(values);
        }
        return null;
    }

    @NotNull
    VcsLogDataPack getDataPack() {
        return (VcsLogDataPack)this.myDataPackProvider.compute();
    }

    void addSetFilterListener(@NotNull Runnable runnable2) {
        this.mySetFilterListeners.add(runnable2);
    }
}

