/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.VcsLogPopupComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FilterPopupComponent<Filter extends VcsLogFilter>
extends VcsLogPopupComponent {
    protected static final String ALL = "All";
    @NotNull
    protected final FilterModel<Filter> myFilterModel;

    FilterPopupComponent(@NotNull String filterName, @NotNull FilterModel<Filter> filterModel) {
        super(filterName);
        this.myFilterModel = filterModel;
    }

    @Override
    public String getCurrentText() {
        Filter filter = this.myFilterModel.getFilter();
        return filter == null ? ALL : this.getText(filter);
    }

    @Override
    public void installChangeListener(@NotNull Runnable onChange) {
        this.myFilterModel.addSetFilterListener(onChange);
    }

    @NotNull
    protected abstract String getText(@NotNull Filter var1);

    @Nullable
    protected abstract String getToolTip(@NotNull Filter var1);

    @Override
    public String getToolTipText() {
        Filter filter = this.myFilterModel.getFilter();
        return filter == null ? null : this.getToolTip(filter);
    }

    @NotNull
    protected AnAction createAllAction() {
        return new AllAction();
    }

    private class AllAction
    extends DumbAwareAction {
        AllAction() {
            super(FilterPopupComponent.ALL);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FilterPopupComponent.this.myFilterModel.setFilter(null);
        }
    }
}

