/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogDateFilterImpl;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogFileFilter;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogHashFilterImpl;
import com.intellij.vcs.log.impl.VcsLogRootFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUserFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogClassicFilterUi
implements VcsLogFilterUi {
    private static final String VCS_LOG_TEXT_FILTER_HISTORY = "Vcs.Log.Text.Filter.History";
    private static final String HASH_PATTERN = "[a-fA-F0-9]{7,}";
    private static final Logger LOG = Logger.getInstance(VcsLogClassicFilterUi.class);
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private VcsLogDataPack myDataPack;
    @NotNull
    private final BranchFilterModel myBranchFilterModel;
    @NotNull
    private final FilterModel<VcsLogUserFilter> myUserFilterModel;
    @NotNull
    private final FilterModel<VcsLogDateFilter> myDateFilterModel;
    @NotNull
    private final FilterModel<VcsLogFileFilter> myStructureFilterModel;
    @NotNull
    private final TextFilterModel myTextFilterModel;

    public VcsLogClassicFilterUi(@NotNull VcsLogUiImpl ui, @NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogDataPack initialDataPack) {
        this.myUi = ui;
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myDataPack = initialDataPack;
        NotNullComputable dataPackGetter = () -> this.myDataPack;
        this.myBranchFilterModel = new BranchFilterModel((Computable<VcsLogDataPack>)dataPackGetter, this.myUiProperties);
        this.myUserFilterModel = new UserFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, uiProperties);
        this.myDateFilterModel = new DateFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, uiProperties);
        this.myStructureFilterModel = new FileFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, this.myLogData.getLogProviders().keySet(), uiProperties);
        this.myTextFilterModel = new TextFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, this.myUiProperties);
        this.updateUiOnFilterChange();
        this.myUi.applyFiltersAndUpdateUi(this.getFilters());
    }

    private void updateUiOnFilterChange() {
        FilterModel[] models;
        for (FilterModel model : models = new FilterModel[]{this.myBranchFilterModel, this.myUserFilterModel, this.myDateFilterModel, this.myStructureFilterModel, this.myTextFilterModel}) {
            model.addSetFilterListener(() -> {
                this.myUi.applyFiltersAndUpdateUi(this.getFilters());
                this.myBranchFilterModel.onStructureFilterChanged(new HashSet<VirtualFile>(this.myLogData.getRoots()), this.myStructureFilterModel.getFilter());
            });
        }
    }

    public void updateDataPack(@NotNull VcsLogDataPack dataPack) {
        this.myDataPack = dataPack;
    }

    @NotNull
    public SearchTextField createTextFilter() {
        return new TextFilterField(this.myTextFilterModel);
    }

    @NotNull
    public ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new BranchFilterPopupComponent(this.myUi, this.myUiProperties, this.myBranchFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new UserFilterPopupComponent(this.myUiProperties, this.myLogData, this.myUserFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new DateFilterPopupComponent(this.myDateFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new StructureFilterPopupComponent(this.myStructureFilterModel, this.myUi.getColorManager()).initUi())));
        return actionGroup;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Pair<VcsLogTextFilter, VcsLogHashFilter> filtersFromText = VcsLogClassicFilterUi.getFiltersFromTextArea((VcsLogTextFilter)this.myTextFilterModel.getFilter(), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE));
        return new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder().with((VcsLogBranchFilter)this.myBranchFilterModel.getFilter()).with(this.myUserFilterModel.getFilter()).with((VcsLogHashFilter)filtersFromText.second).with(this.myDateFilterModel.getFilter()).with((VcsLogTextFilter)filtersFromText.first).with(this.myStructureFilterModel.getFilter() == null ? null : this.myStructureFilterModel.getFilter().getStructureFilter()).with(this.myStructureFilterModel.getFilter() == null ? null : this.myStructureFilterModel.getFilter().getRootFilter()).build();
    }

    @NotNull
    private static Pair<VcsLogTextFilter, VcsLogHashFilter> getFiltersFromTextArea(@Nullable VcsLogTextFilter filter, boolean isRegexAllowed, boolean matchesCase) {
        VcsLogHashFilterImpl hashFilter;
        VcsLogTextFilterImpl textFilter;
        String word;
        if (filter == null) {
            return Pair.empty();
        }
        String text = filter.getText().trim();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return Pair.empty();
        }
        ArrayList hashes = ContainerUtil.newArrayList();
        Iterator iterator = StringUtil.split((String)text, (String)" ").iterator();
        while (iterator.hasNext() && !StringUtil.isEmptyOrSpaces((String)(word = (String)iterator.next())) && word.matches(HASH_PATTERN)) {
            hashes.add(word);
        }
        if (!hashes.isEmpty()) {
            textFilter = null;
            hashFilter = new VcsLogHashFilterImpl(hashes);
        } else {
            textFilter = new VcsLogTextFilterImpl(text, isRegexAllowed, matchesCase);
            hashFilter = null;
        }
        return Pair.create((Object)textFilter, (Object)hashFilter);
    }

    public void setFilter(@NotNull VcsLogFilter filter) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (filter instanceof VcsLogBranchFilter) {
            this.myBranchFilterModel.setFilter((VcsLogBranchFilter)filter);
        } else if (filter instanceof VcsLogStructureFilter) {
            this.myStructureFilterModel.setFilter(new VcsLogFileFilter((VcsLogStructureFilter)filter, null));
        }
        JComponent toolbar = this.myUi.getToolbar();
        toolbar.revalidate();
        toolbar.repaint();
    }

    private static class TextFilterField
    extends SearchTextFieldWithStoredHistory {
        @NotNull
        private final TextFilterModel myTextFilterModel;

        public TextFilterField(@NotNull TextFilterModel model) {
            super(VcsLogClassicFilterUi.VCS_LOG_TEXT_FILTER_HISTORY);
            this.myTextFilterModel = model;
            this.setText(this.myTextFilterModel.getText());
            this.getTextEditor().addActionListener(e -> this.applyFilter());
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    try {
                        myTextFilterModel.setUnsavedText(e.getDocument().getText(0, e.getDocument().getLength()));
                    }
                    catch (BadLocationException ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            });
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"Vcs.Log.FocusTextFilter");
            if (!shortcutText.isEmpty()) {
                this.getTextEditor().setToolTipText("Use " + shortcutText + " to switch between text filter and commits list");
            }
        }

        protected void applyFilter() {
            this.myTextFilterModel.setFilter(new VcsLogTextFilterImpl(this.getText(), this.myTextFilterModel.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myTextFilterModel.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE)));
            this.addCurrentTextToHistory();
        }

        protected void onFieldCleared() {
            this.myTextFilterModel.setFilter((VcsLogTextFilter)null);
        }

        protected void onFocusLost() {
            if (this.myTextFilterModel.hasUnsavedChanges()) {
                this.applyFilter();
            }
        }
    }

    private class UserFilterModel
    extends FilterModel<VcsLogUserFilter> {
        public UserFilterModel(NotNullComputable<VcsLogDataPack> dataPackGetter, MainVcsLogUiProperties uiProperties) {
            super("user", (Computable<VcsLogDataPack>)dataPackGetter, uiProperties);
        }

        @Override
        @NotNull
        protected VcsLogUserFilter createFilter(@NotNull List<String> values) {
            return new VcsLogUserFilterImpl(values, VcsLogClassicFilterUi.this.myLogData.getCurrentUser(), VcsLogClassicFilterUi.this.myLogData.getAllUsers());
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogUserFilter filter) {
            return ContainerUtil.newArrayList(((VcsLogUserFilterImpl)filter).getUserNamesForPresentation());
        }
    }

    private static class DateFilterModel
    extends FilterModel<VcsLogDateFilter> {
        public DateFilterModel(NotNullComputable<VcsLogDataPack> dataPackGetter, MainVcsLogUiProperties uiProperties) {
            super("date", (Computable<VcsLogDataPack>)dataPackGetter, uiProperties);
        }

        @Override
        @Nullable
        protected VcsLogDateFilter createFilter(@NotNull List<String> values) {
            if (values.size() != 2) {
                LOG.warn("Can not create date filter from " + values + " before and after dates are required.");
                return null;
            }
            String after2 = values.get(0);
            String before = values.get(1);
            try {
                return new VcsLogDateFilterImpl(after2.isEmpty() ? null : new Date(Long.parseLong(after2)), before.isEmpty() ? null : new Date(Long.parseLong(before)));
            }
            catch (NumberFormatException e) {
                LOG.warn("Can not create date filter from " + values);
                return null;
            }
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogDateFilter filter) {
            Date after2 = filter.getAfter();
            Date before = filter.getBefore();
            return Arrays.asList(after2 == null ? "" : Long.toString(after2.getTime()), before == null ? "" : Long.toString(before.getTime()));
        }
    }

    private static class FileFilterModel
    extends FilterModel<VcsLogFileFilter> {
        @NotNull
        private static final String ROOTS = "roots";
        @NotNull
        private static final String STRUCTURE = "structure";
        @NotNull
        private final Set<VirtualFile> myRoots;

        public FileFilterModel(NotNullComputable<VcsLogDataPack> dataPackGetter, @NotNull Set<VirtualFile> roots, MainVcsLogUiProperties uiProperties) {
            super("file", (Computable<VcsLogDataPack>)dataPackGetter, uiProperties);
            this.myRoots = roots;
        }

        @Override
        protected void saveFilter(@Nullable VcsLogFileFilter filter) {
            if (filter == null) {
                this.myUiProperties.saveFilterValues(ROOTS, null);
                this.myUiProperties.saveFilterValues(STRUCTURE, null);
            } else if (filter.getStructureFilter() != null) {
                this.myUiProperties.saveFilterValues(STRUCTURE, FileFilterModel.getFilterValues(filter.getStructureFilter()));
            } else if (filter.getRootFilter() != null) {
                this.myUiProperties.saveFilterValues(ROOTS, FileFilterModel.getFilterValues(filter.getRootFilter()));
            }
        }

        @NotNull
        private static List<String> getFilterValues(@NotNull VcsLogStructureFilter filter) {
            return ContainerUtil.map((Collection)filter.getFiles(), FilePath::getPath);
        }

        @NotNull
        private static List<String> getFilterValues(@NotNull VcsLogRootFilter filter) {
            return ContainerUtil.map((Collection)filter.getRoots(), VirtualFile::getPath);
        }

        @Override
        @Nullable
        protected VcsLogFileFilter getLastFilter() {
            List<String> values = this.myUiProperties.getFilterValues(STRUCTURE);
            if (values != null) {
                return new VcsLogFileFilter(FileFilterModel.createStructureFilter(values), null);
            }
            values = this.myUiProperties.getFilterValues(ROOTS);
            if (values != null) {
                return new VcsLogFileFilter(null, this.createRootsFilter(values));
            }
            return null;
        }

        @Nullable
        private VcsLogRootFilter createRootsFilter(@NotNull List<String> values) {
            ArrayList selectedRoots = ContainerUtil.newArrayList();
            for (String path : values) {
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
                if (root != null) {
                    if (this.myRoots.contains(root)) {
                        selectedRoots.add(root);
                        continue;
                    }
                    LOG.warn("Can not find VCS root for filtering " + root);
                    continue;
                }
                LOG.warn("Can not filter by file that does not exist " + path);
            }
            if (selectedRoots.isEmpty()) {
                return null;
            }
            return new VcsLogRootFilterImpl(selectedRoots);
        }

        @NotNull
        private static VcsLogStructureFilter createStructureFilter(@NotNull List<String> values) {
            return new VcsLogStructureFilterImpl(ContainerUtil.map(values, VcsUtil::getFilePath));
        }

        @Override
        @NotNull
        protected VcsLogFileFilter createFilter(@NotNull List<String> values) {
            throw new UnsupportedOperationException("Can not create file filter from list of strings");
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogFileFilter filter) {
            throw new UnsupportedOperationException("Can not save file filter to a list of strings");
        }
    }

    private static class TextFilterModel
    extends FilterModel<VcsLogTextFilter> {
        @Nullable
        private String myText;

        public TextFilterModel(NotNullComputable<VcsLogDataPack> dataPackProvider, @NotNull MainVcsLogUiProperties properties) {
            super("text", (Computable<VcsLogDataPack>)dataPackProvider, properties);
        }

        @NotNull
        String getText() {
            if (this.myText != null) {
                return this.myText;
            }
            if (this.getFilter() != null) {
                return ((VcsLogTextFilter)this.getFilter()).getText();
            }
            return "";
        }

        void setUnsavedText(@NotNull String text) {
            this.myText = text;
        }

        boolean hasUnsavedChanges() {
            if (this.myText == null) {
                return false;
            }
            return this.getFilter() == null || !this.myText.equals(((VcsLogTextFilter)this.getFilter()).getText());
        }

        @Override
        void setFilter(@Nullable VcsLogTextFilter filter) {
            super.setFilter(filter);
            this.myText = null;
        }

        @Override
        @NotNull
        protected VcsLogTextFilter createFilter(@NotNull List<String> values) {
            return new VcsLogTextFilterImpl((String)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(values)), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE));
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogTextFilter filter) {
            return Collections.singletonList(filter.getText());
        }
    }

    public static class BranchFilterModel
    extends FilterModel<VcsLogBranchFilter> {
        @Nullable
        private Collection<VirtualFile> myVisibleRoots;

        BranchFilterModel(@NotNull Computable<VcsLogDataPack> provider2, @NotNull MainVcsLogUiProperties properties) {
            super("branch", provider2, properties);
        }

        public void onStructureFilterChanged(@NotNull Set<VirtualFile> roots, @Nullable VcsLogFileFilter filter) {
            this.myVisibleRoots = filter == null ? null : VcsLogUtil.getAllVisibleRoots(roots, filter.getRootFilter(), filter.getStructureFilter());
        }

        @Nullable
        public Collection<VirtualFile> getVisibleRoots() {
            return this.myVisibleRoots;
        }

        @Override
        @NotNull
        protected VcsLogBranchFilter createFilter(@NotNull List<String> values) {
            return VcsLogBranchFilterImpl.fromTextPresentation(values, ContainerUtil.map2Set((Collection)this.getDataPack().getRefs().getBranches(), VcsRef::getName));
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogBranchFilter filter) {
            return ContainerUtil.newArrayList((Iterable)ContainerUtil.sorted((Collection)filter.getTextPresentation()));
        }
    }

    private static class FilterActionComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final Computable<JComponent> myComponentCreator;

        public FilterActionComponent(@NotNull Computable<JComponent> componentCreator) {
            this.myComponentCreator = componentCreator;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            return (JComponent)this.myComponentCreator.compute();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
        }
    }
}

