/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.ui.frame.CommitPanel;
import com.intellij.vcs.log.ui.frame.WrappedFlowLayout;
import com.intellij.vcs.log.ui.render.LabelIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencesPanel
extends JPanel {
    public static final int H_GAP = 4;
    protected static final int V_GAP = 0;
    public static final int PADDING = 3;
    private final int myRefsLimit;
    @NotNull
    private List<VcsRef> myReferences;
    @NotNull
    protected MultiMap<VcsRefType, VcsRef> myGroupedVisibleReferences;

    public ReferencesPanel() {
        this((LayoutManager)new WrappedFlowLayout(JBUI.scale((int)4), JBUI.scale((int)0)), -1);
    }

    public ReferencesPanel(LayoutManager layout, int limit) {
        super(layout);
        this.myRefsLimit = limit;
        this.myReferences = Collections.emptyList();
        this.myGroupedVisibleReferences = MultiMap.create();
        this.setOpaque(false);
    }

    public void setReferences(@NotNull List<VcsRef> references) {
        this.myReferences = references;
        List<VcsRef> visibleReferences = this.myRefsLimit > 0 ? this.myReferences.subList(0, Math.min(this.myReferences.size(), this.myRefsLimit)) : this.myReferences;
        this.myGroupedVisibleReferences = ContainerUtil.groupBy(visibleReferences, VcsRef::getType);
        this.update();
    }

    public void update() {
        this.removeAll();
        int height = this.getIconHeight();
        JBLabel firstLabel = null;
        for (Map.Entry typeAndRefs : this.myGroupedVisibleReferences.entrySet()) {
            VcsRefType type2 = (VcsRefType)typeAndRefs.getKey();
            Collection refs = (Collection)typeAndRefs.getValue();
            int refIndex = 0;
            for (VcsRef reference : refs) {
                Icon icon = this.createIcon(type2, refs, refIndex, height);
                String ending = refIndex != refs.size() - 1 ? "," : "";
                String text = reference.getName() + ending;
                JBLabel label = this.createLabel(text, icon);
                if (firstLabel == null) {
                    firstLabel = label;
                    this.add((Component)label);
                } else {
                    this.addWrapped(label, firstLabel);
                }
                ++refIndex;
            }
        }
        if (this.getHiddenReferencesSize() > 0) {
            JBLabel label = this.createRestLabel(this.getHiddenReferencesSize());
            this.addWrapped(label, (JBLabel)ObjectUtils.assertNotNull(firstLabel));
        }
        this.setVisible(!this.myGroupedVisibleReferences.isEmpty());
        this.revalidate();
        this.repaint();
    }

    private int getHiddenReferencesSize() {
        return this.myRefsLimit > 0 ? this.myReferences.size() - Math.min(this.myReferences.size(), this.myRefsLimit) : 0;
    }

    protected int getIconHeight() {
        return this.getFontMetrics(this.getLabelsFont()).getHeight() + JBUI.scale((int)3);
    }

    @NotNull
    protected JBLabel createRestLabel(int restSize) {
        return this.createLabel("... " + restSize + " more", null);
    }

    @Nullable
    protected Icon createIcon(@NotNull VcsRefType type2, @NotNull Collection<VcsRef> refs, int refIndex, int height) {
        if (refIndex == 0) {
            Color[] colorArray;
            Color color = type2.getBackgroundColor();
            Color color2 = this.getBackground();
            if (refs.size() > 1) {
                Color[] colorArray2 = new Color[2];
                colorArray2[0] = color;
                colorArray = colorArray2;
                colorArray2[1] = color;
            } else {
                Color[] colorArray3 = new Color[1];
                colorArray = colorArray3;
                colorArray3[0] = color;
            }
            return new LabelIcon(height, color2, colorArray);
        }
        return null;
    }

    private void addWrapped(@NotNull JBLabel label, @NotNull JBLabel referent) {
        Wrapper wrapper = new Wrapper((JComponent)label);
        wrapper.setVerticalSizeReferent((JComponent)referent);
        this.add((Component)wrapper);
    }

    @NotNull
    protected JBLabel createLabel(@NotNull String text, @Nullable Icon icon) {
        JBLabel label = new JBLabel(text, icon, 2);
        label.setFont(this.getLabelsFont());
        label.setIconTextGap(0);
        label.setHorizontalAlignment(2);
        return label;
    }

    @NotNull
    protected Font getLabelsFont() {
        return VcsHistoryUtil.getCommitDetailsFont();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    @Override
    public Color getBackground() {
        return CommitPanel.getCommitDetailsBackground();
    }
}

