/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.SwingUtilities;

public class WrappedFlowLayout
extends FlowLayout {
    public WrappedFlowLayout(int hgap, int vgap) {
        super(3, hgap, vgap);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension baseSize = super.preferredLayoutSize(target);
        if (this.getAlignOnBaseline()) {
            return baseSize;
        }
        return this.getWrappedSize(target);
    }

    public Dimension getWrappedSize(Container target) {
        Container parent = SwingUtilities.getUnwrappedParent(target);
        int maxWidth = parent.getWidth() - (parent.getInsets().left + parent.getInsets().right);
        return this.getDimension(target, maxWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getDimension(Container target, int maxWidth) {
        Insets insets = target.getInsets();
        int height = insets.top + insets.bottom;
        int width = insets.left + insets.right;
        int rowHeight = 0;
        int rowWidth = insets.left + insets.right;
        boolean isVisible = false;
        boolean start = true;
        Object object = target.getTreeLock();
        synchronized (object) {
            for (int i2 = 0; i2 < target.getComponentCount(); ++i2) {
                Component component = target.getComponent(i2);
                if (!component.isVisible()) continue;
                isVisible = true;
                Dimension size = component.getPreferredSize();
                if (rowWidth + this.getHgap() + size.width > maxWidth && !start) {
                    height += this.getVgap() + rowHeight;
                    width = Math.max(width, rowWidth);
                    rowWidth = insets.left + insets.right;
                    rowHeight = 0;
                }
                rowWidth += this.getHgap() + size.width;
                rowHeight = Math.max(rowHeight, size.height);
                start = false;
            }
            height += this.getVgap() + rowHeight;
            width = Math.max(width, rowWidth);
            if (!isVisible) {
                return super.preferredLayoutSize(target);
            }
            return new Dimension(width, height);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        if (this.getAlignOnBaseline()) {
            return super.minimumLayoutSize(target);
        }
        return this.getWrappedSize(target);
    }
}

