/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.highlighters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentBranchHighlighter
implements VcsLogHighlighter {
    private static final JBColor CURRENT_BRANCH_BG = new JBColor(new Color(228, 250, 255), new Color(63, 71, 73));
    private static final String HEAD = "HEAD";
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUi myLogUi;
    @NotNull
    private final Map<VirtualFile, Condition<CommitId>> myConditions = ContainerUtil.newHashMap();
    @Nullable
    private String mySingleFilteredBranch;

    public CurrentBranchHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
        this.myLogData = logData;
        this.myLogUi = logUi;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(@NotNull VcsShortCommitDetails details, boolean isSelected) {
        if (isSelected || !this.myLogUi.isHighlighterEnabled("CURRENT_BRANCH")) {
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }
        Condition<CommitId> condition2 = this.myConditions.get(details.getRoot());
        if (condition2 == null) {
            VcsLogProvider provider2 = this.myLogData.getLogProvider(details.getRoot());
            String currentBranch = provider2.getCurrentBranch(details.getRoot());
            if (!HEAD.equals(this.mySingleFilteredBranch) && currentBranch != null && !currentBranch.equals(this.mySingleFilteredBranch)) {
                condition2 = this.myLogData.getContainingBranchesGetter().getContainedInBranchCondition(currentBranch, details.getRoot());
                this.myConditions.put(details.getRoot(), condition2);
            } else {
                condition2 = Conditions.alwaysFalse();
            }
        }
        if (condition2 != null && condition2.value((Object)new CommitId((Hash)details.getId(), details.getRoot()))) {
            return VcsCommitStyleFactory.background((Color)CURRENT_BRANCH_BG);
        }
        return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        VcsLogBranchFilter branchFilter = dataPack.getFilters().getBranchFilter();
        this.mySingleFilteredBranch = branchFilter == null ? null : VcsLogUtil.getSingleFilteredBranch(branchFilter, dataPack.getRefs());
        this.myConditions.clear();
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        public static final String ID = "CURRENT_BRANCH";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
            return new CurrentBranchHighlighter(logData, logUi);
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            return "Current Branch";
        }

        @Override
        public boolean showMenuItem() {
            return true;
        }
    }
}

