/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.ui.history.FileHistoryUiProperties;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class FileHistoryFilterUi
implements VcsLogFilterUi {
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final FileHistoryUiProperties myProperties;

    public FileHistoryFilterUi(@NotNull FilePath path, @NotNull FileHistoryUiProperties properties) {
        this.myPath = path;
        this.myProperties = properties;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogStructureFilterImpl fileFilter = new VcsLogStructureFilterImpl((Collection<FilePath>)Collections.singleton(this.myPath));
        VcsLogBranchFilterImpl branchFilter = this.myProperties.get(FileHistoryUiProperties.SHOW_ALL_BRANCHES) != false ? null : VcsLogBranchFilterImpl.fromBranch("HEAD");
        return new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder().with(fileFilter).with(branchFilter).build();
    }

    public void setFilter(@NotNull VcsLogFilter filter) {
        throw new UnsupportedOperationException();
    }
}

